/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.field;

import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.field.UserList;
import com.suncode.pwfl.workflow.form.field.UserListAttributes;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleUsers
extends UserList {
    private static final Logger log = LoggerFactory.getLogger(RoleUsers.class);

    public RoleUsers(ActivityService activityService) {
        super(activityService, false);
        this.setName("ROLEUSERS");
    }

    @Override
    public void readSpecificAttribute(ExtendedAttribute attr) {
        String attrValue = attr.getVValue();
        log.info("Attribute value: {}", (Object)attrValue);
        String[] split = attrValue.split("\n");
        this.updateActivityEAValueCustomKey(split);
    }

    private void updateActivityEAValueCustomKey(String[] split) {
        String roleIds = "";
        String ouNames = "";
        String ouSymbols = "";
        String group = "";
        String subordinate = "";
        String superior = "";
        for (int i = 1; i < split.length; ++i) {
            String[] line = split[i].split("=");
            String param = line[0];
            String value = line[1];
            if (param.equalsIgnoreCase("role")) {
                value = roleIds.equals("") ? value : "," + value;
                roleIds = roleIds + value;
                continue;
            }
            if (param.equalsIgnoreCase("ou")) {
                value = ouNames.equals("") ? value : "," + value;
                ouNames = ouNames + value;
                continue;
            }
            if (param.equalsIgnoreCase("ou_symbol")) {
                value = ouSymbols.equals("") ? value : "," + value;
                ouSymbols = ouSymbols + value;
                continue;
            }
            if (param.equalsIgnoreCase("group")) {
                value = group.equals("") ? value : "," + value;
                group = group + value;
                continue;
            }
            if (param.equalsIgnoreCase("subordinate")) {
                value = subordinate.equals("") ? value : "," + value;
                subordinate = subordinate + value;
                continue;
            }
            if (param.equalsIgnoreCase("superior")) {
                value = superior.equals("") ? value : "," + value;
                superior = superior + value;
                continue;
            }
            throw new ServiceException("Pole typu ROLEUSERS musi posiada\u0107 wiersze postaci role=<id_roli> lub ou=<nazwa_ou> lub ou_symbols=<symbol_ou> lub group=<group> lub subordinate=<id_podw\u0142adnego> lub superior=<id_prze\u0142o\u017conego>. B\u0142\u0105d w lini: " + split[i]);
        }
        String valueToAppend = "";
        if (roleIds.length() > 0) {
            valueToAppend = valueToAppend + "\nrole=" + roleIds;
        }
        if (ouNames.length() > 0) {
            valueToAppend = valueToAppend + "\nou=" + ouNames;
        }
        if (ouSymbols.length() > 0) {
            valueToAppend = valueToAppend + "\nou_symbol=" + ouSymbols;
        }
        if (group.length() > 0) {
            valueToAppend = valueToAppend + "\ngroup=" + group;
        }
        if (subordinate.length() > 0) {
            valueToAppend = valueToAppend + "\nsubordinate=" + subordinate;
        }
        if (superior.length() > 0) {
            valueToAppend = valueToAppend + "\nsuperior=" + superior;
        }
        String prevValue = this.getCustomKeys().get(UserListAttributes.CUSTOM_KEYS_KEYS[1]);
        this.getCustomKeys().put(UserListAttributes.CUSTOM_KEYS_KEYS[1], prevValue + valueToAppend);
    }
}

