/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.component.declaration;

import com.google.common.collect.Maps;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.component.declaration.ConditionDeclaration;
import com.suncode.pwfl.workflow.component.declaration.FunctionDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ComponentDeclaration {
    private String id;
    private ConditionDeclaration condition;
    private boolean inactive;
    private Map<String, ParameterDeclaration> parameters = Maps.newLinkedHashMap();

    public ComponentDeclaration(String id) {
        Assert.hasText((String)id);
        this.id = id;
    }

    public ComponentDeclaration(String id, boolean inactive) {
        this(id);
        this.inactive = inactive;
    }

    public ComponentDeclaration(String id, ConditionDeclaration condition, boolean inactive) {
        this(id);
        this.inactive = inactive;
        this.condition = condition;
    }

    public ParameterDeclaration getParameter(String name) {
        return this.parameters.get(name);
    }

    public void addParameter(String name, ParameterDeclaration parameter) {
        this.parameters.put(name, parameter);
    }

    public void changeParameter(String name, ParameterDeclaration parameter) {
        if (this.parameters.get(name) != null) {
            this.parameters.put(name, parameter);
        }
    }

    public List<String> collectVariablesUsedInParameters() {
        ArrayList<String> criteria = new ArrayList<String>();
        this.parameters.values().forEach(parameter -> this.collectDataChoosersCriteria((ParameterDeclaration)parameter, (List<String>)criteria));
        return criteria;
    }

    private void collectDataChoosersCriteria(ParameterDeclaration parameter, List<String> criteria) {
        if (parameter.isArray()) {
            for (ParameterValue parameterValue : (List)parameter.getValue()) {
                this.evalSingle(parameterValue, criteria);
            }
        } else {
            this.evalSingle((ParameterValue)parameter.getValue(), criteria);
        }
    }

    private void evalSingle(ParameterValue parameterValue, List<String> criteria) {
        FunctionDeclaration functionDeclaration;
        Type<?> type = parameterValue.getType();
        if (type == Types.VARIABLE && StringUtils.isNotBlank((CharSequence)((CharSequence)parameterValue.getValue()))) {
            criteria.add((String)parameterValue.getValue());
        } else if (type == Types.FUNCTION && (functionDeclaration = (FunctionDeclaration)parameterValue.getValue()) != null && functionDeclaration.getParameters() != null) {
            functionDeclaration.getParameters().forEach(parameter -> this.collectDataChoosersCriteria((ParameterDeclaration)parameter, criteria));
        }
    }

    public ComponentDeclaration() {
    }

    public String getId() {
        return this.id;
    }

    public ConditionDeclaration getCondition() {
        return this.condition;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public Map<String, ParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCondition(ConditionDeclaration condition) {
        this.condition = condition;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public void setParameters(Map<String, ParameterDeclaration> parameters) {
        this.parameters = parameters;
    }
}

