/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.DelegatedActivity;
import com.suncode.pwfl.workflow.activity.FinishedUserActivity;
import com.suncode.pwfl.workflow.activity.UserActivity;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsNotSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import java.util.List;
import java.util.Map;

public interface ActivityService {
    public void openActivity(String var1, String var2, String var3) throws UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException, ActivityIsSuspendedException;

    @Deprecated
    public void openActivity(String var1, String var2, String var3, String var4) throws UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException, ActivityIsSuspendedException;

    @Deprecated
    public void openActivity(String var1, String var2, String var3, String var4, String var5) throws Exception;

    public void setActivityContext(String var1, String var2, Map<String, Object> var3);

    public Map<String, Object> getActivityContext(String var1, String var2);

    public Activity getActivity(String var1, String var2, String ... var3);

    public DelegatedActivity getActivityDelegation(String var1, String var2);

    public List<DelegatedActivity> getActivityDelegations(String var1, String var2);

    public List<DelegatedActivity> getActivityDelegations(String var1);

    public void addActivityDelegation(DelegatedActivity var1);

    public void deleteActivityDelegation(DelegatedActivity var1);

    public void acceptActivity(AcceptationDefinition var1);

    public List<String> getAssignments(String var1, String var2);

    public String getActivityName(String var1, String var2);

    public void changeState(String var1, String var2, ActivityState var3);

    public boolean changeStateIfPossible(String var1, String var2, ActivityState var3);

    public void abort(String var1, String var2);

    public void deleteActivities(List<Activity> var1);

    public void suspendActivity(String var1, String var2) throws ActivityAlreadyCompletedException;

    public void suspendActivity(String var1, String var2, boolean var3) throws ActivityAlreadyCompletedException;

    public void resumeActivity(String var1, String var2) throws ActivityIsNotSuspendedException;

    public void resumeActivity(String var1, String var2, boolean var3) throws ActivityIsNotSuspendedException;

    public List<Activity> getOpenActivitiesForProcess(String var1);

    public CountedResult<UserActivity> getOpenActivitiesAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<UserActivity> getNewActivitiesAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<UserActivity> getRunningActivitiesAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<UserActivity> getWaitingToStartActivitiesAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<UserActivity> getActivitiesInSubstitutionAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<UserActivity> getOpenActivitiesWithExceededDeadlineAssignedToUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<FinishedUserActivity> getAllFinishedActivitiesForUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<FinishedUserActivity> getFailedFinishedActivitiesForUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<FinishedUserActivity> getSuccessfulFinishedActivitiesForUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public CountedResult<FinishedUserActivity> getProcessingFinishedActivitiesForUser(String var1, List<String> var2, Integer var3, Integer var4, String var5, SortDirection var6);

    public List<String> getProcessDefIdsForOpenActivitiesAssignedToUser(String var1);

    public List<String> getProcessDefIdsForNewActivitiesAssignedToUser(String var1);

    public List<String> getProcessDefIdsForRunningActivitiesAssignedToUser(String var1);

    public List<String> getProcessDefIdsForWaitingToStartActivitiesAssignedToUser(String var1);

    public List<String> getProcessDefIdsForActivitiesInSubstitutionAssignedToUser(String var1);

    public List<String> getProcessDefIdsForActivitiesWithExceededDeadlineAssignedToUser(String var1);

    public List<String> getProcessDefIdsForAllFinishedActivities(String var1);

    public List<String> getProcessDefIdsForFailedFinishedActivities(String var1);

    public List<String> getProcessDefIdsForSuccessfulFinishedActivities(String var1);

    public List<String> getProcessDefIdsForProcessingFinishedActivities(String var1);

    public long countOpenActivitiesAssignedToUser(String var1, List<String> var2);

    public long countNewActivitiesAssignedToUser(String var1, List<String> var2);

    public long countRunningActivitiesAssignedToUser(String var1, List<String> var2);

    public long countWaitingToStartActivitiesAssignedToUser(String var1, List<String> var2);

    public long countActivitiesInSubstitutionAssignedToUser(String var1, List<String> var2);

    public long countOpenActivitiesWithExceededDeadlineAssignedToUser(String var1, List<String> var2);

    public long countAllFinishedActivitiesForUser(String var1, List<String> var2);

    public long countFailedFinishedActivitiesForUser(String var1, List<String> var2);

    public long countSuccessfulFinishedActivitiesForUser(String var1, List<String> var2);

    public long countProcessingFinishedActivitiesForUser(String var1, List<String> var2);
}

