/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonSerializable;
import java.lang.reflect.Array;
import org.springframework.util.Assert;

public class ArrayType<T>
extends TypeBase<T[]>
implements JsonSerializable<T[]> {
    Type<T> elementType;

    ArrayType(Type<T> elementType, T[] defaultValue) {
        super(ArrayType.arrayType(defaultValue), defaultValue);
        this.setForceInstanceWhenReading(false);
        this.elementType = elementType;
    }

    static <T> ArrayType<T> of(Type<T> elementType) {
        return new ArrayType<T>(elementType, ArrayType.emptyArray(elementType.javaType()));
    }

    @Override
    public final String name() {
        return this.elementType.name() + "[]";
    }

    public final Type<T> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isInstance(Class<?> type) {
        return type.isArray() && this.elementType.isInstance(type.getComponentType());
    }

    @Override
    protected <I, O> O doReadAs(I value, Class<I> in, Class<O> out) {
        int length = Array.getLength(value);
        Object result = Array.newInstance(out.getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, this.elementType.readAs(Array.get(value, i), out.getComponentType()));
        }
        return (O)result;
    }

    private static <T> Class<T[]> arrayType(T[] array) {
        return array.getClass();
    }

    private static <T> T[] emptyArray(Class<T> componentClass) {
        return (Object[])Array.newInstance(componentClass, 0);
    }

    @Override
    public JsonNode serializeJson(T[] value) {
        this.assertElementTypeSerializable();
        if (value == null) {
            return NullNode.getInstance();
        }
        JsonSerializable serializer = (JsonSerializable)((Object)this.elementType);
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (T item : value) {
            arrayNode.add(serializer.serializeJson(item));
        }
        return arrayNode;
    }

    @Override
    public T[] deserializeJson(JsonNode json) {
        this.assertElementTypeSerializable();
        if (json.isNull()) {
            return null;
        }
        JsonSerializable serializer = (JsonSerializable)((Object)this.elementType);
        ArrayNode items = (ArrayNode)json;
        Object[] result = (Object[])Array.newInstance(this.javaType(), items.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = serializer.deserializeJson(items.get(i));
        }
        return result;
    }

    private void assertElementTypeSerializable() {
        Assert.state((boolean)(this.elementType instanceof JsonSerializable), (String)("Array elements type must implement " + JsonSerializable.class.getName() + " interface"));
    }

    @Override
    public T[] convert(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        String[] splittedValues = value.split(";");
        Object[] result = (Object[])Array.newInstance(this.elementType.javaType(), splittedValues.length);
        for (int i = 0; i < splittedValues.length; ++i) {
            result[i] = this.elementType.convert(splittedValues[i]);
        }
        return result;
    }
}

