/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduledTaskMethodDto {
    private String name;
    private String className;
    private String returns;
    private String annotationName;
    private String annotationDesc;
    private String category;
    private Boolean isComponent = false;
    private String componentTaskId;
    private Boolean deprecated;
    private Boolean cancelable;
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public String toString() {
        return ScheduledTaskMethodDto.simpleClassName(this.className) + "#" + this.name + this.parameters.stream().sorted(Comparator.comparing(Parameter::getPosition)).map(Parameter::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String simpleClassName(String className) {
        if (className == null) {
            return "(null)";
        }
        int arrayDimensions = (int)className.chars().filter(character -> character == 91).count();
        String rawClassName = className.substring(arrayDimensions);
        if (rawClassName.startsWith("L") && rawClassName.endsWith(";")) {
            rawClassName = rawClassName.substring(1, rawClassName.length() - 1);
        }
        String simpleClassName = rawClassName.substring(1 + rawClassName.lastIndexOf("."));
        StringBuilder simpleClassNameBuilder = new StringBuilder(simpleClassName);
        for (int i = 0; i < arrayDimensions; ++i) {
            simpleClassNameBuilder.append("[]");
        }
        return simpleClassNameBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getReturns() {
        return this.returns;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getAnnotationDesc() {
        return this.annotationDesc;
    }

    public String getCategory() {
        return this.category;
    }

    public Boolean getIsComponent() {
        return this.isComponent;
    }

    public String getComponentTaskId() {
        return this.componentTaskId;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Boolean getCancelable() {
        return this.cancelable;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setReturns(String returns) {
        this.returns = returns;
    }

    public void setAnnotationName(String annotationName) {
        this.annotationName = annotationName;
    }

    public void setAnnotationDesc(String annotationDesc) {
        this.annotationDesc = annotationDesc;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setIsComponent(Boolean isComponent) {
        this.isComponent = isComponent;
    }

    public void setComponentTaskId(String componentTaskId) {
        this.componentTaskId = componentTaskId;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setCancelable(Boolean cancelable) {
        this.cancelable = cancelable;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Parameter {
        private Integer position;
        private String type;
        private String fieldType;
        private String annotationName;
        private String annotationDesc;
        private String componentParameterId;
        private Boolean isOptional = false;
        private Object defaultValue;

        public String toString() {
            return ScheduledTaskMethodDto.simpleClassName(this.type);
        }

        public Integer getPosition() {
            return this.position;
        }

        public String getType() {
            return this.type;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getAnnotationName() {
            return this.annotationName;
        }

        public String getAnnotationDesc() {
            return this.annotationDesc;
        }

        public String getComponentParameterId() {
            return this.componentParameterId;
        }

        public Boolean getIsOptional() {
            return this.isOptional;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public void setAnnotationName(String annotationName) {
            this.annotationName = annotationName;
        }

        public void setAnnotationDesc(String annotationDesc) {
            this.annotationDesc = annotationDesc;
        }

        public void setComponentParameterId(String componentParameterId) {
            this.componentParameterId = componentParameterId;
        }

        public void setIsOptional(Boolean isOptional) {
            this.isOptional = isOptional;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

