/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email.oauth.client;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2AuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_oauth_client")
@SequenceGenerator(name="pm_oauth_client_id_seq", sequenceName="pm_oauth_client_id_seq")
public class OAuth2Client {
    public static final String JOIN_CONNECTIONS = "connections";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_oauth_client_id_seq")
    private Long id;
    private String name;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private OAuth2AuthenticationMethod authenticationMethod;
    @Column(length=512)
    private String clientId;
    @Column(length=512)
    private String clientSecret;
    @Column(length=512)
    private String scope;
    @Column(length=512)
    private String authorizationUrl;
    @Column(length=512)
    private String tokenUrl;
    @Column(length=512)
    private String redirectUrl;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="clientid")
    private List<OAuth2Connection> connections;

    public String getDecryptedClientSecret() {
        if (StringUtils.isNotEmpty((CharSequence)this.clientSecret)) {
            try {
                return TextCipher.decrypt(this.clientSecret);
            }
            catch (Exception e) {
                throw new DecryptingException();
            }
        }
        return this.clientSecret;
    }

    public void setEncryptedClientSecret(String clientSecret) {
        if (StringUtils.isNotEmpty((CharSequence)clientSecret)) {
            try {
                this.clientSecret = TextCipher.encrypt(clientSecret);
            }
            catch (Exception e) {
                throw new EncryptingException();
            }
        } else {
            this.clientSecret = clientSecret;
        }
    }

    public static OAuth2ClientBuilder builder() {
        return new OAuth2ClientBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OAuth2AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public List<OAuth2Connection> getConnections() {
        return this.connections;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthenticationMethod(OAuth2AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setConnections(List<OAuth2Connection> connections) {
        this.connections = connections;
    }

    public OAuth2Client() {
    }

    @ConstructorProperties(value={"id", "name", "authenticationMethod", "clientId", "clientSecret", "scope", "authorizationUrl", "tokenUrl", "redirectUrl", "connections"})
    public OAuth2Client(Long id, String name, OAuth2AuthenticationMethod authenticationMethod, String clientId, String clientSecret, String scope, String authorizationUrl, String tokenUrl, String redirectUrl, List<OAuth2Connection> connections) {
        this.id = id;
        this.name = name;
        this.authenticationMethod = authenticationMethod;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
        this.redirectUrl = redirectUrl;
        this.connections = connections;
    }

    public static class OAuth2ClientBuilder {
        private Long id;
        private String name;
        private OAuth2AuthenticationMethod authenticationMethod;
        private String clientId;
        private String clientSecret;
        private String scope;
        private String authorizationUrl;
        private String tokenUrl;
        private String redirectUrl;
        private List<OAuth2Connection> connections;

        public OAuth2ClientBuilder encryptedClientSecret(String clientSecret) {
            if (StringUtils.isNotEmpty((CharSequence)clientSecret)) {
                try {
                    this.clientSecret = TextCipher.encrypt(clientSecret);
                }
                catch (Exception e) {
                    throw new EncryptingException();
                }
            } else {
                this.clientSecret = clientSecret;
            }
            return this;
        }

        OAuth2ClientBuilder() {
        }

        public OAuth2ClientBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public OAuth2ClientBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OAuth2ClientBuilder authenticationMethod(OAuth2AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public OAuth2ClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuth2ClientBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuth2ClientBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuth2ClientBuilder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public OAuth2ClientBuilder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public OAuth2ClientBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public OAuth2ClientBuilder connections(List<OAuth2Connection> connections) {
            this.connections = connections;
            return this;
        }

        public OAuth2Client build() {
            return new OAuth2Client(this.id, this.name, this.authenticationMethod, this.clientId, this.clientSecret, this.scope, this.authorizationUrl, this.tokenUrl, this.redirectUrl, this.connections);
        }

        public String toString() {
            return "OAuth2Client.OAuth2ClientBuilder(id=" + this.id + ", name=" + this.name + ", authenticationMethod=" + (Object)((Object)this.authenticationMethod) + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", authorizationUrl=" + this.authorizationUrl + ", tokenUrl=" + this.tokenUrl + ", redirectUrl=" + this.redirectUrl + ", connections=" + this.connections + ")";
        }
    }
}

