/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask.info.execution;

import java.beans.ConstructorProperties;
import java.util.Arrays;

public enum ScheduledTaskState {
    NOT_STARTED(0),
    RUNNING(1),
    CANCELLING(2),
    DONE(3);

    private final int stateId;

    static ScheduledTaskState getByStateId(int stateId) {
        return Arrays.stream(ScheduledTaskState.values()).filter(status -> status.stateId == stateId).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Scheduled task state by id %s does not exists", stateId)));
    }

    @ConstructorProperties(value={"stateId"})
    private ScheduledTaskState(int stateId) {
        this.stateId = stateId;
    }
}

