/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.support.BaseDao;
import com.suncode.pwfl.support.BaseFinder;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseFinderImpl<T, PK extends Serializable, Dao extends BaseDao<T, PK>>
implements BaseFinder<T, PK> {
    protected Dao dao;
    protected Class<?> type;

    @Override
    @Transactional(readOnly=true)
    public List<T> findByCriteria(DetachedCriteria dc, Integer firstResult, Integer maxResult) {
        return this.dao.findByCriteria(dc, firstResult, maxResult);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByCriteria(DetachedCriteria dc) {
        return this.dao.findByCriteria(dc);
    }

    @Override
    @Transactional(readOnly=true)
    public T findOneByProperty(String property, Object value, String ... joins) {
        return this.dao.findOneByProperty(property, value, joins);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByProperty(String property, Object value, Integer start, Integer limit, String ... joins) {
        return this.dao.findByProperty(property, value, start, limit, joins);
    }

    @Override
    @Transactional(readOnly=true)
    public T findOne(DetachedCriteria dc) {
        return this.dao.findOne(dc);
    }

    @Override
    @Transactional(readOnly=true)
    public T get(PK id) {
        return this.dao.get(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> getAll(String ... joins) {
        return this.getAll((Integer)null, (Integer)null, joins);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> getAll(Integer start, Integer limit, String ... joins) {
        if (start == null || limit == null) {
            return this.dao.getAll(joins);
        }
        return this.dao.getAll(start, limit, joins);
    }

    @Override
    @Transactional(readOnly=true)
    public T get(PK id, String ... joins) {
        return this.dao.get(id, joins);
    }

    public BaseFinderImpl() {
        if (this.getClass().getGenericSuperclass() instanceof ParameterizedType) {
            this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
    }

    @Override
    @Transactional(readOnly=true)
    public long count(DetachedCriteria dc) {
        return this.dao.countByCriteria(dc);
    }

    @Override
    @Transactional(readOnly=true)
    public long countAll() {
        return this.dao.countAll();
    }

    protected void addLike(String field, String value, DetachedCriteria dc) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            dc.add(Restrictions.ilike((String)field, (Object)value));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CountedResult<T> getCountedResult(DetachedCriteria dc, Sorter sorter, Integer start, Integer limit) {
        long total = this.count(dc);
        dc.setProjection(null);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (sorter != null) {
            if (sorter.getDirection() == SortDirection.ASC) {
                dc.addOrder(Order.asc((String)sorter.getProperty()));
            } else {
                dc.addOrder(Order.desc((String)sorter.getProperty()));
            }
        }
        List<T> list = this.findByCriteria(dc, start, limit);
        CountedResult<T> result = new CountedResult<T>();
        result.setData(list);
        result.setTotal(total);
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public CountedResult<T> getCountedResult(DetachedCriteria dc, Pagination pagination) {
        return this.getCountedResult(dc, pagination.getSorter(), pagination.getStart(), pagination.getLimit());
    }
}

