/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.datasource.dao;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.InvocableDataSource;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import com.suncode.pwfl.workflow.component.declaration.ComponentDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclarationReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Entity(name="pm_datasource")
public class DataSourceDeclaration
extends ComponentDeclaration {
    private String type;
    private String name;
    private String description;
    private byte[] serializedParameters = new byte[0];
    private DataSourceOperation operation;
    private String replaceSemicolonsChar;
    private Boolean allowCache;
    private Long cacheExpirationDelaySec;

    public DataSourceDeclaration(String id, String type, String name, String description, Map<String, ParameterDeclaration> parameters, DataSourceOperation operation, String replaceSemicolonsChar, Boolean allowCache, Long cacheExpirationDelaySec) {
        super(id);
        this.type = type;
        this.name = name;
        this.description = description;
        this.setParameters(parameters);
        this.operation = operation;
        this.replaceSemicolonsChar = replaceSemicolonsChar;
        this.allowCache = allowCache;
        this.cacheExpirationDelaySec = cacheExpirationDelaySec;
    }

    @Override
    @Id
    @Column(nullable=false)
    public String getId() {
        return super.getId();
    }

    @Lob
    @JsonIgnore
    @Column(name="parameters")
    private byte[] getSerializedParameters() {
        return this.serializedParameters;
    }

    @Column
    public String getName() {
        return LocalizedString.of(this.name).get();
    }

    @Column
    public String getDescription() {
        return StringUtils.isNotEmpty((CharSequence)this.description) ? LocalizedString.of(this.description).get() : "";
    }

    @Column
    public String getReplaceSemicolonsChar() {
        return this.replaceSemicolonsChar;
    }

    @Column(nullable=false)
    public Boolean getAllowCache() {
        return this.allowCache;
    }

    @Column(nullable=false)
    public Long getCacheExpirationDelaySec() {
        return this.cacheExpirationDelaySec;
    }

    @Enumerated(value=EnumType.STRING)
    @Column
    public DataSourceOperation getOperation() {
        WorkflowComponentRegistry registry;
        InvocableDataSource component;
        if (this.operation == null && (component = (registry = SpringContext.getBean(WorkflowComponentRegistry.class)).getDataSource(this.type)) != null && CollectionUtils.isNotEmpty(component.getOperations()) && component.getOperations().iterator().hasNext()) {
            return component.getOperations().iterator().next();
        }
        return this.operation;
    }

    @Override
    public void setParameters(Map<String, ParameterDeclaration> parameters) {
        try {
            this.serializedParameters = SpringContext.getBean(ParameterDeclarationReader.class).serializeAsBytes(parameters);
            super.setParameters(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Transient
    public Map<String, ParameterDeclaration> getParameters() {
        try {
            if (super.getParameters() == null || super.getParameters().isEmpty()) {
                super.setParameters(this.serializedParameters.length > 0 ? SpringContext.getBean(ParameterDeclarationReader.class).deserialize(this.serializedParameters) : Collections.emptyMap());
            }
            return super.getParameters();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ParameterDeclaration getParameter(String name) {
        return this.getParameters().get(name);
    }

    public static DataSourceDeclarationBuilder builder() {
        return new DataSourceDeclarationBuilder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSerializedParameters(byte[] serializedParameters) {
        this.serializedParameters = serializedParameters;
    }

    public void setOperation(DataSourceOperation operation) {
        this.operation = operation;
    }

    public void setReplaceSemicolonsChar(String replaceSemicolonsChar) {
        this.replaceSemicolonsChar = replaceSemicolonsChar;
    }

    public void setAllowCache(Boolean allowCache) {
        this.allowCache = allowCache;
    }

    public void setCacheExpirationDelaySec(Long cacheExpirationDelaySec) {
        this.cacheExpirationDelaySec = cacheExpirationDelaySec;
    }

    public String toString() {
        return "DataSourceDeclaration(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serializedParameters=" + Arrays.toString(this.getSerializedParameters()) + ", operation=" + (Object)((Object)this.getOperation()) + ", replaceSemicolonsChar=" + this.getReplaceSemicolonsChar() + ", allowCache=" + this.getAllowCache() + ", cacheExpirationDelaySec=" + this.getCacheExpirationDelaySec() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceDeclaration)) {
            return false;
        }
        DataSourceDeclaration other = (DataSourceDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (!Arrays.equals(this.getSerializedParameters(), other.getSerializedParameters())) {
            return false;
        }
        DataSourceOperation this$operation = this.getOperation();
        DataSourceOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        String this$replaceSemicolonsChar = this.getReplaceSemicolonsChar();
        String other$replaceSemicolonsChar = other.getReplaceSemicolonsChar();
        if (this$replaceSemicolonsChar == null ? other$replaceSemicolonsChar != null : !this$replaceSemicolonsChar.equals(other$replaceSemicolonsChar)) {
            return false;
        }
        Boolean this$allowCache = this.getAllowCache();
        Boolean other$allowCache = other.getAllowCache();
        if (this$allowCache == null ? other$allowCache != null : !((Object)this$allowCache).equals(other$allowCache)) {
            return false;
        }
        Long this$cacheExpirationDelaySec = this.getCacheExpirationDelaySec();
        Long other$cacheExpirationDelaySec = other.getCacheExpirationDelaySec();
        return !(this$cacheExpirationDelaySec == null ? other$cacheExpirationDelaySec != null : !((Object)this$cacheExpirationDelaySec).equals(other$cacheExpirationDelaySec));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceDeclaration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSerializedParameters());
        DataSourceOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        String $replaceSemicolonsChar = this.getReplaceSemicolonsChar();
        result = result * 59 + ($replaceSemicolonsChar == null ? 43 : $replaceSemicolonsChar.hashCode());
        Boolean $allowCache = this.getAllowCache();
        result = result * 59 + ($allowCache == null ? 43 : ((Object)$allowCache).hashCode());
        Long $cacheExpirationDelaySec = this.getCacheExpirationDelaySec();
        result = result * 59 + ($cacheExpirationDelaySec == null ? 43 : ((Object)$cacheExpirationDelaySec).hashCode());
        return result;
    }

    public DataSourceDeclaration() {
    }

    public static class DataSourceDeclarationBuilder {
        private String id;
        private String type;
        private String name;
        private String description;
        private Map<String, ParameterDeclaration> parameters;
        private DataSourceOperation operation;
        private String replaceSemicolonsChar;
        private Boolean allowCache;
        private Long cacheExpirationDelaySec;

        DataSourceDeclarationBuilder() {
        }

        public DataSourceDeclarationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DataSourceDeclarationBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DataSourceDeclarationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DataSourceDeclarationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DataSourceDeclarationBuilder parameters(Map<String, ParameterDeclaration> parameters) {
            this.parameters = parameters;
            return this;
        }

        public DataSourceDeclarationBuilder operation(DataSourceOperation operation) {
            this.operation = operation;
            return this;
        }

        public DataSourceDeclarationBuilder replaceSemicolonsChar(String replaceSemicolonsChar) {
            this.replaceSemicolonsChar = replaceSemicolonsChar;
            return this;
        }

        public DataSourceDeclarationBuilder allowCache(Boolean allowCache) {
            this.allowCache = allowCache;
            return this;
        }

        public DataSourceDeclarationBuilder cacheExpirationDelaySec(Long cacheExpirationDelaySec) {
            this.cacheExpirationDelaySec = cacheExpirationDelaySec;
            return this;
        }

        public DataSourceDeclaration build() {
            return new DataSourceDeclaration(this.id, this.type, this.name, this.description, this.parameters, this.operation, this.replaceSemicolonsChar, this.allowCache, this.cacheExpirationDelaySec);
        }

        public String toString() {
            return "DataSourceDeclaration.DataSourceDeclarationBuilder(id=" + this.id + ", type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ", operation=" + (Object)((Object)this.operation) + ", replaceSemicolonsChar=" + this.replaceSemicolonsChar + ", allowCache=" + this.allowCache + ", cacheExpirationDelaySec=" + this.cacheExpirationDelaySec + ")";
        }
    }
}

