/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.archive;

import com.suncode.pwfl.administration.archive.AssociatedIndexes;
import com.suncode.pwfl.administration.archive.DisplayedIndex;
import com.suncode.pwfl.archive.DocumentClass;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="pm_classesassociation", uniqueConstraints={@UniqueConstraint(columnNames={"parent_id", "child_id"})})
@SequenceGenerator(name="pm_classesassociation_id_seq", sequenceName="pm_classesassociation_id_seq")
public class DocumentClassAssociation {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_classesassociation_id_seq")
    private Long id;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private DocumentClass parentClass;
    @ManyToOne
    @JoinColumn(name="child_id")
    private DocumentClass childClass;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="documentClassAssociation", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<AssociatedIndexes> associatedIndexes;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="documentClassAssociation", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<DisplayedIndex> displayedChildIndexes;
    private String separator;
    private boolean associateOnEmptyValues;

    public static DocumentClassAssociationBuilder builder() {
        return new DocumentClassAssociationBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public DocumentClass getParentClass() {
        return this.parentClass;
    }

    public DocumentClass getChildClass() {
        return this.childClass;
    }

    public List<AssociatedIndexes> getAssociatedIndexes() {
        return this.associatedIndexes;
    }

    public List<DisplayedIndex> getDisplayedChildIndexes() {
        return this.displayedChildIndexes;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isAssociateOnEmptyValues() {
        return this.associateOnEmptyValues;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParentClass(DocumentClass parentClass) {
        this.parentClass = parentClass;
    }

    public void setChildClass(DocumentClass childClass) {
        this.childClass = childClass;
    }

    public void setAssociatedIndexes(List<AssociatedIndexes> associatedIndexes) {
        this.associatedIndexes = associatedIndexes;
    }

    public void setDisplayedChildIndexes(List<DisplayedIndex> displayedChildIndexes) {
        this.displayedChildIndexes = displayedChildIndexes;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setAssociateOnEmptyValues(boolean associateOnEmptyValues) {
        this.associateOnEmptyValues = associateOnEmptyValues;
    }

    public DocumentClassAssociation() {
    }

    @ConstructorProperties(value={"id", "parentClass", "childClass", "associatedIndexes", "displayedChildIndexes", "separator", "associateOnEmptyValues"})
    public DocumentClassAssociation(Long id, DocumentClass parentClass, DocumentClass childClass, List<AssociatedIndexes> associatedIndexes, List<DisplayedIndex> displayedChildIndexes, String separator, boolean associateOnEmptyValues) {
        this.id = id;
        this.parentClass = parentClass;
        this.childClass = childClass;
        this.associatedIndexes = associatedIndexes;
        this.displayedChildIndexes = displayedChildIndexes;
        this.separator = separator;
        this.associateOnEmptyValues = associateOnEmptyValues;
    }

    public static class DocumentClassAssociationBuilder {
        private Long id;
        private DocumentClass parentClass;
        private DocumentClass childClass;
        private List<AssociatedIndexes> associatedIndexes;
        private List<DisplayedIndex> displayedChildIndexes;
        private String separator;
        private boolean associateOnEmptyValues;

        DocumentClassAssociationBuilder() {
        }

        public DocumentClassAssociationBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DocumentClassAssociationBuilder parentClass(DocumentClass parentClass) {
            this.parentClass = parentClass;
            return this;
        }

        public DocumentClassAssociationBuilder childClass(DocumentClass childClass) {
            this.childClass = childClass;
            return this;
        }

        public DocumentClassAssociationBuilder associatedIndexes(List<AssociatedIndexes> associatedIndexes) {
            this.associatedIndexes = associatedIndexes;
            return this;
        }

        public DocumentClassAssociationBuilder displayedChildIndexes(List<DisplayedIndex> displayedChildIndexes) {
            this.displayedChildIndexes = displayedChildIndexes;
            return this;
        }

        public DocumentClassAssociationBuilder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public DocumentClassAssociationBuilder associateOnEmptyValues(boolean associateOnEmptyValues) {
            this.associateOnEmptyValues = associateOnEmptyValues;
            return this;
        }

        public DocumentClassAssociation build() {
            return new DocumentClassAssociation(this.id, this.parentClass, this.childClass, this.associatedIndexes, this.displayedChildIndexes, this.separator, this.associateOnEmptyValues);
        }

        public String toString() {
            return "DocumentClassAssociation.DocumentClassAssociationBuilder(id=" + this.id + ", parentClass=" + this.parentClass + ", childClass=" + this.childClass + ", associatedIndexes=" + this.associatedIndexes + ", displayedChildIndexes=" + this.displayedChildIndexes + ", separator=" + this.separator + ", associateOnEmptyValues=" + this.associateOnEmptyValues + ")";
        }
    }
}

