/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.SystemContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserAvatarProperties {
    private static final Logger log = LoggerFactory.getLogger(UserAvatarProperties.class);
    public static final long AVATAR_FILE_SIZE_LIMIT = 0x500000L;
    public static final int AVATAR_SIZE = 150;
    public static final int AVATAR_SIZE_MINI = 30;
    public static byte[] DEFAULT_AVATAR;

    @PostConstruct
    private void init() {
        DEFAULT_AVATAR = this.getDefaultAvatar();
    }

    private byte[] getDefaultAvatar() {
        byte[] avatar;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String imagePath = "/resources/images/avatar-default.png";
            BufferedImage bImage = ImageIO.read(new File(SystemContext.get().getServletContext().getRealPath(imagePath).replace("\\", "/")));
            ImageIO.write((RenderedImage)bImage, "png", bos);
            avatar = bos.toByteArray();
        }
        catch (Throwable t) {
            avatar = new byte[]{};
            log.error("Default avatar init error: " + t.getMessage());
        }
        return avatar;
    }
}

