/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process;

import com.suncode.pwfl.workflow.process.exception.IndexTypeNotSupportedException;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

public enum IndexType {
    STRING,
    INTEGER,
    DOUBLE,
    DATE,
    BOOLEAN;


    public static IndexType fromString(String type) {
        switch (type) {
            case "DATE": 
            case "java.util.Date": {
                return DATE;
            }
            case "AMOUNT": 
            case "java.lang.Double": {
                return DOUBLE;
            }
            case "java.lang.Long": {
                return INTEGER;
            }
            case "java.lang.String": {
                return STRING;
            }
            case "java.lang.Boolean": {
                return BOOLEAN;
            }
        }
        throw new IndexTypeNotSupportedException(type);
    }

    public static IndexType toIndexType(DataField dataField) {
        String javaType;
        switch (javaType = dataField.getDataType().getJavaType()) {
            case "DATE": 
            case "java.util.Date": {
                return DATE;
            }
            case "AMOUNT": 
            case "java.lang.Double": {
                return DOUBLE;
            }
            case "java.lang.Long": {
                return INTEGER;
            }
            case "java.lang.String": {
                ExtendedAttribute subtypeAttribute = dataField.getExtendedAttributes().getFirstExtendedAttributeForName("SUBTYPE");
                String subType = subtypeAttribute != null ? subtypeAttribute.getVValue() : "";
                boolean isTableVariable = dataField.getExtendedAttributes().getFirstExtendedAttributeForName("ARRAY").getVValue().equals("TRUE");
                return subType.equals("DATE") && !isTableVariable ? DATE : STRING;
            }
            case "java.lang.Boolean": {
                return BOOLEAN;
            }
        }
        throw new IndexTypeNotSupportedException(javaType);
    }
}

