/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import java.util.Arrays;
import java.util.Optional;

public enum DefinedSystemParameter {
    OPTIONAL_VIEWS_RIGHT("Rights.Views.Enabled", false),
    OPTIONAL_USER_ACCOUNT_RIGHT("Rights.UserAccount.Enabled", false),
    UNIVERSAL_PASSWORD("UniversalPassword", "PlusMPMAdmin2008"),
    SYSTEM_TYPE("SystemType", "Production"),
    SYSTEM_NAME("SystemName", ""),
    ACTIVATE_DEADLINE_NOTIFICATIONS("ActivateDeadlineNotifications", true, true),
    PM_IDX_SHORT_TIMESTAMP_FORMAT_ENABLED("PM_IDX.ShortTimestampFormat.Enabled", true),
    ACTIVITYFORM_LIVEVALIDATION("activityform.livevalidation", true),
    CACHE_DATACHOOSER_LIMIT("Cache.DataChooser.Limit", 100000L),
    CACHE_DATACHOOSER_EXPIREAFTER("Cache.DataChooser.ExpireAfter", 1200L),
    FORM_DATEFIELD_FORMAT("Form.DateField.Format", ""),
    FORM_DOCUMENTVIEW_PINBYDEFAULT("Form.DocumentView.PinByDefault", true),
    FORM_DATACHOOSER_AUTOMAPPING_ENABLED("Form.DataChooser.AutoMapping.Enabled", false),
    CLIENTSCRIPTS_CACHING("ClientScripts.Caching", "VERSION"),
    CLIENTSCRIPTS_CACHEMAXAGE("ClientScripts.CacheMaxAge", 600L),
    DECIMAL_SEPARATOR("DecimalSeparator", ","),
    ACTIVITYFORM_THOUSANDSEPARATOR("activityform.thousandseparator", " "),
    BUFOR_USERNAME("Bufor.username", "admin"),
    BUFOR_PASSWORD("Bufor.password", ""),
    AUTHENTICATION_INTERCEPTORCLASS("Authentication.InterceptorClass", "", true),
    AUTHENTICATION_INTERCEPTORCLASSSINGLETON("Authentication.InterceptorClassSingleton", true, true),
    AUTHORIZE_USER_FOR_FILE("AuthorizeUserForFile", true),
    AUTO_LOGIN("AutoLogin", false),
    CASE_SENSITIVE_LOGIN("CaseSensitiveLogin", true),
    SINGLE_SESSION("SingleSession", false),
    DEFAULTMAILMESSAGEHANDLER_BUFFERED_ENABLED("DefaultMailMessageHandler.Buffered.Enabled", false, true),
    DEFAULTMAILMESSAGEHANDLER_BUFFERED_PERIOD("DefaultMailMessageHandler.Buffered.Period", 30000L, true),
    DEFAULTMAILMESSAGEHANDLER_BUFFERED_TRYAFTER("DefaultMailMessageHandler.Buffered.TryAfter", 60000L),
    DEFAULTMAILMESSAGEHANDLER_BUFFERED_MAXATTEMPTS("DefaultMailMessageHandler.Buffered.MaxAttempts", 5L),
    HTTPLINK("HTTPLink", "http://localhost:8080/PlusWorkflow"),
    HTTPPREFIX("httpPrefix", "http:"),
    DOCUMENT_EXPIRATION_PERIOD("DocumentExpirationPeriod", 5L, true),
    ADDITIONAL_FILE_RIGHTS("AdditionalFileRights", ""),
    REPORT_PDF_EMPTYVALUE("Report.PDF.EmptyValue", null),
    ARCHIVE_DOCUMENTCLASS_SEARCH_FULLTEXT_ENABLED("Archive.DocumentClass.Search.FullText.Enabled", false),
    ARCHIVE_DOCUMENTCLASS_SEARCH_FULLTEXT_LIMIT("Archive.DocumentClass.Search.FullText.Limit", 500L),
    SEARCH_CELLS_LIMIT("SearchCellsLimit", 300000L),
    USE_SYSTEM_ADVANCE_SEARCH_EXCEL_EXPORT("UseSystemAdvanceSearchExcelExport", true),
    USE_SYSTEM_ADVANCE_SEARCH_CSV_EXPORT("UseSystemAdvanceSearchCsvExport", true),
    CHECK_TEXT_AS_NUMBER_IN_ADVANCE_SEARCH_EXPORT("CheckTextAsNumberInAdvanceSearchExport", false),
    PACK_SIZE_IN_ADVANCE_SEARCH_EXPORT("PackSizeInAdvanceSearchExport", 1000L),
    USE_SYSTEM_REPORT_EXCEL_EXPORT("UseSystemReportExcelExport", true),
    USE_SYSTEM_ARCHIVE_EXCEL_EXPORT("UseSystemArchiveExcelExport", true),
    NOLOCK("NOLOCK", true),
    DT_CONF_GETLOCALVALUE("DT_CONF.GetLocalValue", true),
    STRUTS_FORM_SIZE("STRUTS_FORM_SIZE", 300L, true),
    CACHE_MENUTAB_EXPIRATIONTIME("Cache.MenuTab.ExpirationTime", 60L, true),
    DEFAULTMAILMESSAGEHANDLER_SMTPMAILSERVER("DefaultMailMessageHandler.SMTPMailServer", ""),
    DEFAULTMAILMESSAGEHANDLER_SMTPPORTNO("DefaultMailMessageHandler.SMTPPortNo", 25L),
    DEFAULTMAILMESSAGEHANDLER_SMTPUSER("DefaultMailMessageHandler.SMTPUser", ""),
    DEFAULTMAILMESSAGEHANDLER_USER("DefaultMailMessageHandler.User", ""),
    DEFAULTMAILMESSAGEHANDLER_MAILSERVER("DefaultMailMessageHandler.MailServer", ""),
    DEFAULTMAILMESSAGEHANDLER_USERPASSWORD("DefaultMailMessageHandler.UserPassword", ""),
    DEFAULTMAILMESSAGEHANDLER_SOURCEADDRESS("DefaultMailMessageHandler.SourceAddress", "System PlusWorkflow"),
    DEFAULTMAILMESSAGEHANDLER_SMTPAUTH("DefaultMailMessageHandler.SMTPAuth", true),
    DEFAULTMAILMESSAGEHANDLER_EMAIL("DefaultMailMessageHandler.Email", ""),
    DEFAULTMAILMESSAGEHANDLER_USESSL("DefaultMailMessageHandler.UseSSL", false),
    DEFAULTMAILMESSAGEHANDLER_USESTARTTLS("DefaultMailMessageHandler.UseSTARTTLS", false),
    DEFAULTMAILMESSAGEHANDLER_TIMEOUT("DefaultMailMessageHandler.Timeout", 300000L),
    DEFAULTMAILMESSAGEHANDLER_DEBUG("DefaultMailMessageHandler.Debug", false),
    SCHEDULEDTASKS_SYSTEM_INIT_DELAY("ScheduledTasks.SYSTEM_INIT_DELAY", 5L, true),
    SCHEDULEDTASKS_CORE_POOL_SIZE("ScheduledTasks.CORE_POOL_SIZE", 0L, true),
    SCHEDULEDTASKS_KEEP_ALIVE_TIME("ScheduledTasks.KEEP_ALIVE_TIME", 30L, true),
    SCHEDULEDTASKS_TERMINATION_AWAIT_TIME("ScheduledTasks.TERMINATION_AWAIT_TIME", 1L, true),
    SCHEDULEDTASKS_HISTORY_VALIDITY("ScheduledTasks.HISTORY_VALIDITY", 30L, true),
    DELEGATION_TYPE("DelegationType", "ALL"),
    SUBSTITUTIONS_PERIOD("SubstitutionsPeriod", null),
    DELEGATION_USERLISTTYPE("Delegation.UserListType", "allUsers"),
    DELEGATION_CUSTOMCLASS("Delegation.CustomClass", ""),
    AFTER_ADD_DELEGATION("AfterAddDelegation", ""),
    EMPTY_TASK_USER_NAME("EmptyTaskUserName", "admin"),
    ACTIVITYACCEPTANCEPOOL_MAXIMUMPOOLSIZE("ActivityAcceptancePool.maximumPoolSize", 15L, true),
    ACTIVITYACCEPTANCEPOOL_KEEPALIVETIME("ActivityAcceptancePool.keepAliveTime", 30L, true),
    ACTIVITYACCEPTANCEPOOL_TERMINATIONTIMEOUT("ActivityAcceptancePool.terminationTimeout", -1L, true),
    PATH_TO_XPDL_BUNDLE("PATH_TO_XPDL_BUNDLE", "", true),
    PATH_TO_CUSTOM_BUNDLE("PATH_TO_CUSTOM_BUNDLE", "", true),
    WORKING_DIRECTORY("WorkingDirectory", System.getProperty("java.io.tmpdir")),
    SUPPORTED_LANGUAGES("SupportedLanguages", "en;pl", true),
    EXACT_SEARCH("ExactSearch", true),
    CAPTCHA_LOGIN_ATTEMPTS("CaptchaLoginAttempts", null),
    PASSWORD_RECOVERY_ENABLED("PasswordRecoveryEnabled", false),
    SHOW_CALENDAR_CART("ShowCalendarCart", false),
    ADMIN_PASSWORD("AdminPassword", ""),
    CUSTOM_HOLIDAYS("CustomHolidays", ""),
    ADVANCED_SEARCH("Views.AdvancedSearch", true),
    ADDITIONAL_CAPTCHA_CONFIRMATION("AdditionalCaptchaConfirmation", false),
    DOCUMENTATION_LINK("DocumentationLink", "docs.plusworkflow.pl"),
    IGNORE_RIGHTS_FROM_CLIENT("IgnoreRightsFromClient", false),
    AGGREGATE_ARRAY_VARIABLES_ENABLED("Views.AdvancedSearch.AggregateArrayVariables.Enabled", false),
    HTTP_HEADER_SECURITY_NOSNIFF_DISABLED("HttpHeaderSecurity.Nosniff.Disabled", false, false),
    SPNEGO_PREAUTH_USERNAME("spnego.preauth.username", "Administrator", true),
    SPNEGO_PREAUTH_PASSWORD("spnego.preauth.password", "plusmpm", true),
    SHOW_EXTERNAL_DATABASE_CART("ShowExternalDatabaseCart", false),
    CHECK_SESSION_CREATOR_IP("CheckSessionCreatorIP", false),
    UNIVERSAL_PASSWORD_ALLOW_MOBILE("UniversalPasswordAllowMobile", false),
    HTTP_HEADER_SECURITY_SAMEORIGIN_DISABLED("HttpHeaderSecurity.Sameorigin.Disabled", false, false),
    LOGS_LIMIT("Logs.Limit", 2L),
    LOGS_PARAMS_LIMIT("Logs.ParamsLimit", 100L),
    PDF_CONVERTER("PdfConverter", "Standard"),
    CORS_WHITELIST("HttpHeaderSecurity.CorsWhitelist", null),
    SAMESITE_COOKIE_MODE("SameSiteCookieMode", "Unset"),
    USE_SECURE_COOKIE("UseSecureCookie", false),
    SELF_PASSWORD_ASSIGN_LINK_EXPIRATION_TIME("SelfPasswordAssignLinkExpirationTime", 24L),
    SHOW_STATISTICS("ShowStatistics", false),
    NEW_ACTIVITY_TIME_MINUTES("NewActivityTimeMinutes", 1440L, false),
    SHOW_MODULES_TAB("ShowModulesTab", false),
    ELASTIC_MAX_RESULT_WINDOW("ElasticMaxResultWindow", 100000L),
    ELASTIC_ENABLED("ElasticEnabled", false),
    ELASTIC_MAX_INNER_RESULT_WINDOW("ElasticMaxInnerResultWindow", 100L),
    ELASTIC_COMPLETED_ACTIVITIES_CACHE_EXP_TIME("ElasticCompletedActivitiesCacheExpTime", 3L, true),
    HIDE_LOGIN_FORM("HideLoginForm", false),
    HTTP_HEADER_SECURITY_CONTENT_SECURITY_POLICY("HttpHeaderSecurity.ContentSecurityPolicy", "", false),
    HTTP_HEADER_SECURITY_REFERRER_POLICY("HttpHeaderSecurity.ReferrerPolicy", "strict-origin-when-cross-origin"),
    CASE_SENSITIVE_DISABLED("CaseSensitive.Disabled", false),
    ELASTIC_REQUEST_TIMEOUT("ElasticRequestTimeout", 30L, true),
    SHARK_PROCESS_LOCK_SHORT_TIMEOUT("Shark.ProcessLock.ShortTimeoutSeconds", 20L, false),
    SHARK_TRANSACTION_ACQUIRE_SHORT_TIMEOUT("Shark.TransactionAcquire.ShortTimeoutSeconds", 20L, false);

    private String key;
    private Object defaultValue;
    private Boolean needsRestart;

    private DefinedSystemParameter(String key, Object defaultValue) {
        this(key, defaultValue, false);
    }

    private DefinedSystemParameter(String key, Object defaultValue, Boolean needsRestart) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.needsRestart = needsRestart;
    }

    public String getKey() {
        return this.key;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static DefinedSystemParameter byKey(String key) {
        Optional<DefinedSystemParameter> result = Arrays.stream(DefinedSystemParameter.values()).filter(parameter -> parameter.getKey().equals(key)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Cannot find defined parameter for key [" + key + "]");
    }

    public static Boolean doesNeedRestart(String key) {
        try {
            DefinedSystemParameter definedSystemParameter = DefinedSystemParameter.byKey(key);
            return definedSystemParameter.getNeedsRestart();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public Boolean getNeedsRestart() {
        return this.needsRestart;
    }
}

