/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.suncode.pwfl.archive.Directory;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_devices")
@SequenceGenerator(name="pm_devices_id_seq", sequenceName="pm_devices_id_seq")
public class Device {
    public static final String JOIN_DIRECTORIES = "directories";
    private Long id;
    private String deviceName;
    private String devicePath;
    private Long deviceSize;
    private Long deviceFreeSpace;
    private Set<Directory> directories;

    public Device(Long id) {
        this.id = id;
    }

    public Device() {
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_devices_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String path) {
        this.devicePath = path;
    }

    public Long getDeviceSize() {
        return this.deviceSize;
    }

    public void setDeviceSize(Long size) {
        this.deviceSize = size;
    }

    public Long getDeviceFreeSpace() {
        return this.deviceFreeSpace;
    }

    public void setDeviceFreeSpace(Long freeSpace) {
        this.deviceFreeSpace = freeSpace;
    }

    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="device")
    public Set<Directory> getDirectories() {
        if (this.directories == null) {
            this.directories = new HashSet<Directory>();
        }
        return this.directories;
    }

    public void setDirectories(Set<Directory> directories) {
        this.directories = directories;
    }

    public void addDirectory(Directory dir) {
        this.getDirectories().add(dir);
    }

    public static DeviceBuilder builder() {
        return new DeviceBuilder();
    }

    @ConstructorProperties(value={"id", "deviceName", "devicePath", "deviceSize", "deviceFreeSpace", "directories"})
    public Device(Long id, String deviceName, String devicePath, Long deviceSize, Long deviceFreeSpace, Set<Directory> directories) {
        this.id = id;
        this.deviceName = deviceName;
        this.devicePath = devicePath;
        this.deviceSize = deviceSize;
        this.deviceFreeSpace = deviceFreeSpace;
        this.directories = directories;
    }

    public static class DeviceBuilder {
        private Long id;
        private String deviceName;
        private String devicePath;
        private Long deviceSize;
        private Long deviceFreeSpace;
        private Set<Directory> directories;

        DeviceBuilder() {
        }

        public DeviceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DeviceBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceBuilder devicePath(String devicePath) {
            this.devicePath = devicePath;
            return this;
        }

        public DeviceBuilder deviceSize(Long deviceSize) {
            this.deviceSize = deviceSize;
            return this;
        }

        public DeviceBuilder deviceFreeSpace(Long deviceFreeSpace) {
            this.deviceFreeSpace = deviceFreeSpace;
            return this;
        }

        public DeviceBuilder directories(Set<Directory> directories) {
            this.directories = directories;
            return this;
        }

        public Device build() {
            return new Device(this.id, this.deviceName, this.devicePath, this.deviceSize, this.deviceFreeSpace, this.directories);
        }

        public String toString() {
            return "Device.DeviceBuilder(id=" + this.id + ", deviceName=" + this.deviceName + ", devicePath=" + this.devicePath + ", deviceSize=" + this.deviceSize + ", deviceFreeSpace=" + this.deviceFreeSpace + ", directories=" + this.directories + ")";
        }
    }
}

