/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.google.common.collect.Lists;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.ContextVariableBuilder;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.ParameterDefinitionBuilder;
import com.suncode.pwfl.translation.EmptyTranslator;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ComponentDefinitionBuilder<T extends ComponentDefinitionBuilder<T>> {
    protected final Translator translator;
    protected String id;
    protected String documentationLink;
    protected LocalizedString name;
    protected LocalizedString description;
    protected Icon icon;
    protected List<Category> categories = Lists.newArrayList();
    protected List<ParameterDefinition<?>> parameters = Lists.newArrayList();
    protected List<ContextVariable<?>> contextVariables = Lists.newArrayList();
    protected LocalizedString deprecationDescription;

    public ComponentDefinitionBuilder() {
        this(EmptyTranslator.INSTANCE);
    }

    public ComponentDefinitionBuilder(Translator translator) {
        Assert.notNull((Object)translator);
        this.translator = translator;
    }

    protected abstract T getThis();

    public abstract ComponentDefinition create();

    public T id(String id) {
        this.id = id;
        return this.getThis();
    }

    public T documentationLink(String documentationLink) {
        String linkPrefix = SystemProperties.getString(DefinedSystemParameter.DOCUMENTATION_LINK);
        this.documentationLink = StringUtils.isEmpty((Object)linkPrefix) ? null : (linkPrefix.endsWith("/") ? linkPrefix + documentationLink : linkPrefix + "/" + documentationLink);
        return this.getThis();
    }

    public T name(String name) {
        this.name = this.translated(name);
        return this.getThis();
    }

    public T description(String description) {
        this.description = this.translated(description);
        return this.getThis();
    }

    public T deprecationDescription(String deprecationDescription) {
        this.deprecationDescription = this.translated(deprecationDescription);
        return this.getThis();
    }

    public T icon(Icon icon) {
        this.icon = icon;
        return this.getThis();
    }

    public T category(Category ... categories) {
        for (Category category : categories) {
            if (category == null) continue;
            this.categories.add(category);
        }
        return this.getThis();
    }

    public ParameterDefinitionBuilder<T> parameter() {
        return new ParameterDefinitionBuilder(this);
    }

    protected T parameter(ParameterDefinition<?> parameter) {
        this.parameters.add(parameter);
        return this.getThis();
    }

    public ContextVariableBuilder<T> contextVariable() {
        return new ContextVariableBuilder(this);
    }

    protected T contextVariable(ContextVariable<?> variable) {
        this.contextVariables.add(variable);
        return this.getThis();
    }

    public LocalizedString translated(String message) {
        if (StringUtils.hasText((String)message)) {
            return new LocalizedString(message, this.translator, new Object[0]);
        }
        return null;
    }
}

