/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email;

import com.suncode.pwfl.archive.WfDocument;
import java.beans.ConstructorProperties;
import java.io.File;

public class EmailAttachment {
    private File file;
    private String filename;

    public EmailAttachment(File file) {
        this.file = file;
    }

    public EmailAttachment(WfDocument wfDocument) {
        this.file = new File(wfDocument.getFile().getFullPath());
        this.filename = wfDocument.getFile().getFileName();
    }

    public String toString() {
        return "EmailAttachment{file=" + this.file + ", filename='" + this.filename + '\'' + '}';
    }

    public static EmailAttachmentBuilder builder() {
        return new EmailAttachmentBuilder();
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public EmailAttachment() {
    }

    @ConstructorProperties(value={"file", "filename"})
    public EmailAttachment(File file, String filename) {
        this.file = file;
        this.filename = filename;
    }

    public static class EmailAttachmentBuilder {
        private File file;
        private String filename;

        EmailAttachmentBuilder() {
        }

        public EmailAttachmentBuilder file(File file) {
            this.file = file;
            return this;
        }

        public EmailAttachmentBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public EmailAttachment build() {
            return new EmailAttachment(this.file, this.filename);
        }

        public String toString() {
            return "EmailAttachment.EmailAttachmentBuilder(file=" + this.file + ", filename=" + this.filename + ")";
        }
    }
}

