/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.structure;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="pm_roles")
@SequenceGenerator(name="pm_roles_id_seq", sequenceName="pm_roles_id_seq")
public class Role {
    public static final String JOIN_POSITIONS = "positions";
    private Long id;
    private String roleId;
    private String packageId;
    private String processDefId;
    private Set<Position> positions;

    Role() {
    }

    public Role(String packageId, String processDefId, String roleId) {
        this.roleId = roleId;
        this.packageId = packageId;
        this.processDefId = processDefId;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_roles_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="roles")
    public Set<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(Set<Position> positions) {
        this.positions = positions;
    }

    @Transient
    public boolean isPackageLevel() {
        return this.processDefId == null;
    }

    @Transient
    public boolean isProcessLevel() {
        return !this.isPackageLevel();
    }

    @Transient
    public String getRoleName() {
        return PackageTranslationHelper.getRoleName((String)this.packageId, (String)this.processDefId, (String)this.roleId);
    }

    public String toString() {
        return "Role [roleId=" + this.roleId + ", packageId=" + this.packageId + ", processDefId=" + this.processDefId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageId == null ? 0 : this.packageId.hashCode());
        result = 31 * result + (this.processDefId == null ? 0 : this.processDefId.hashCode());
        result = 31 * result + (this.roleId == null ? 0 : this.roleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this.packageId == null ? other.packageId != null : !this.packageId.equals(other.packageId)) {
            return false;
        }
        if (this.processDefId == null ? other.processDefId != null : !this.processDefId.equals(other.processDefId)) {
            return false;
        }
        return !(this.roleId == null ? other.roleId != null : !this.roleId.equals(other.roleId));
    }
}

