/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util;

import com.plusmpm.util.IndexData;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DocumentData
implements Comparable<DocumentData>,
Serializable {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<IndexData> alIndecies = null;
    private long lDocumentId;
    private long lDocClassId;
    private String lDocClassName;
    private String docClassViewName;
    private long lFileId;
    private String sExpiretionDate;
    private String sDocumentDate;
    private long lDocumentRights;
    private boolean expired;
    private String sProcessId;
    private String sActivityId;

    public DocumentData(Map<String, Object> idxData) {
        if (this.alIndecies == null) {
            this.alIndecies = new ArrayList<IndexData>();
        }
        this.lDocumentId = (Long)idxData.get("id");
        this.lFileId = (Long)idxData.get("fileid");
        Date expirationDate = (Date)idxData.get("expiretion_date");
        this.sExpiretionDate = expirationDate != null ? sdf.format(expirationDate) : "";
        this.sDocumentDate = "";
        int expired = (Integer)idxData.get("expired");
        this.expired = expired == 1;
    }

    public DocumentData(long documentId, long fileId, String expiretionDate, String documentDate, int expired) {
        if (this.alIndecies == null) {
            this.alIndecies = new ArrayList<IndexData>();
        }
        this.lDocumentId = documentId;
        this.lFileId = fileId;
        this.sExpiretionDate = expiretionDate;
        this.sDocumentDate = documentDate;
        this.expired = expired == 1;
    }

    public DocumentData() {
        if (this.alIndecies == null) {
            this.alIndecies = new ArrayList<IndexData>();
        }
    }

    public DocumentData(WfDocument document) {
        if (this.alIndecies == null) {
            this.alIndecies = new ArrayList<IndexData>();
        }
        for (IndexInfo ii : document.getIndexes()) {
            IndexData id = new IndexData();
            id.setId(ii.getId());
            if (ii.getValue() != null) {
                if (ii.getType().compareTo(IndexType.DATETIME) == 0) {
                    id.setValue(sdf.format(ii.getValue()));
                } else {
                    id.setValue(String.valueOf(ii.getValue()));
                }
            }
            id.setName(ii.getName());
            this.alIndecies.add(id);
        }
        this.setExpired(document.isExpired());
        this.setLDocClassId(document.getDocumentClassId());
        this.setLDocumentId(document.getId());
        this.setLFileId(document.getFile().getId());
        this.sExpiretionDate = document.getExpirationDate() != null ? sdf.format(document.getExpirationDate()) : "";
    }

    public List<IndexData> getAlIndecies() {
        return this.alIndecies;
    }

    public void setAlIndecies(List<IndexData> alIndecies) {
        this.alIndecies = alIndecies;
    }

    public long getLDocumentId() {
        return this.lDocumentId;
    }

    public void setLDocumentId(long documentId) {
        this.lDocumentId = documentId;
    }

    public long getLFileId() {
        return this.lFileId;
    }

    public void setLFileId(long fileId) {
        this.lFileId = fileId;
    }

    public String getSDocumentDate() {
        return this.sDocumentDate;
    }

    public void setSDocumentDate(String documentDate) {
        this.sDocumentDate = documentDate;
    }

    public String getSExpiretionDate() {
        return this.sExpiretionDate;
    }

    public void setSExpiretionDate(String expiretionDate) {
        this.sExpiretionDate = expiretionDate;
    }

    public String[] getValue() {
        String[] asValues = null;
        if (this.alIndecies != null) {
            int iSize = this.alIndecies.size();
            asValues = new String[iSize];
            for (int i = 0; i < iSize; ++i) {
                IndexData indexData = this.alIndecies.get(i);
                asValues[i] = indexData.getValue();
            }
        }
        return asValues;
    }

    public long getLDocClassId() {
        return this.lDocClassId;
    }

    public void setLDocClassId(long docClassId) {
        this.lDocClassId = docClassId;
    }

    public String getLDocClassName() {
        if (this.lDocClassName == null || this.lDocClassName.compareTo("") == 0) {
            DocumentClassService dcs = ServiceFactory.getDocumentClassService();
            DocumentClass docClassTable = (DocumentClass)dcs.get(this.lDocClassId);
            this.lDocClassName = docClassTable.getName();
        }
        return this.lDocClassName;
    }

    public void setLDocClassName(String docClassName) {
        this.lDocClassName = docClassName;
    }

    public String getDocClassViewName() {
        return this.docClassViewName;
    }

    public void setDocClassViewName(String docClassViewName) {
        this.docClassViewName = docClassViewName;
    }

    public String getSActivityId() {
        return this.sActivityId;
    }

    public void setSActivityId(String activityId) {
        this.sActivityId = activityId;
    }

    public String getSProcessId() {
        return this.sProcessId;
    }

    public void setSProcessId(String processId) {
        this.sProcessId = processId;
    }

    public long getLDocumentRights() {
        return this.lDocumentRights;
    }

    public void setLDocumentRights(long documentRights) {
        this.lDocumentRights = documentRights;
    }

    @Override
    public int compareTo(DocumentData o) {
        return new Long(this.lFileId).compareTo(new Long(o.getLFileId()));
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }
}

