/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.systemMessage;

import com.suncode.pwfl.administration.systemMessage.SystemMessage;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="pm_system_message_read_history", uniqueConstraints={@UniqueConstraint(name="UNIQUE_SYSTEM_MESSAGE_READ_HIS", columnNames={"username", "messageid"})})
@SequenceGenerator(name="pm_system_msg_read_his_id_seq", sequenceName="pm_system_msg_read_his_id_seq")
public class SystemMessageReadHistory {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_system_msg_read_his_id_seq")
    private Long id;
    private String userName;
    private Date readDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="messageid")
    private SystemMessage systemMessage;

    public static SystemMessageReadHistoryBuilder builder() {
        return new SystemMessageReadHistoryBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public Date getReadDate() {
        return this.readDate;
    }

    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setReadDate(Date readDate) {
        this.readDate = readDate;
    }

    public void setSystemMessage(SystemMessage systemMessage) {
        this.systemMessage = systemMessage;
    }

    public SystemMessageReadHistory() {
    }

    @ConstructorProperties(value={"id", "userName", "readDate", "systemMessage"})
    public SystemMessageReadHistory(Long id, String userName, Date readDate, SystemMessage systemMessage) {
        this.id = id;
        this.userName = userName;
        this.readDate = readDate;
        this.systemMessage = systemMessage;
    }

    public static class SystemMessageReadHistoryBuilder {
        private Long id;
        private String userName;
        private Date readDate;
        private SystemMessage systemMessage;

        SystemMessageReadHistoryBuilder() {
        }

        public SystemMessageReadHistoryBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SystemMessageReadHistoryBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public SystemMessageReadHistoryBuilder readDate(Date readDate) {
            this.readDate = readDate;
            return this;
        }

        public SystemMessageReadHistoryBuilder systemMessage(SystemMessage systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public SystemMessageReadHistory build() {
            return new SystemMessageReadHistory(this.id, this.userName, this.readDate, this.systemMessage);
        }

        public String toString() {
            return "SystemMessageReadHistory.SystemMessageReadHistoryBuilder(id=" + this.id + ", userName=" + this.userName + ", readDate=" + this.readDate + ", systemMessage=" + this.systemMessage + ")";
        }
    }
}

