/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.SharkUtilities;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.internal.working.WfActivityInternal;
import org.springframework.util.Assert;

public class ActivityContextMap {
    private final String processId;
    private final String activityId;
    private final Map<String, Variable> context;

    public ActivityContextMap(String processId, String activityId, Map<String, Variable> context) {
        Assert.hasText((String)processId);
        Assert.hasText((String)activityId);
        Assert.notNull(context);
        this.processId = processId;
        this.activityId = activityId;
        this.context = ImmutableMap.copyOf(context);
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public Variable getVariable(String variableId) {
        return this.context.get(variableId);
    }

    public Map<String, Variable> getVariables() {
        return this.context;
    }

    public void synchronize(SharkTransaction transaction) throws BaseException, InvalidData {
        Map<String, Object> values = this.getValuesToSynchronize();
        WfActivityInternal activity = SharkUtilities.getActivity((SharkTransaction)transaction, (String)this.processId, (String)this.activityId);
        activity.set_result(transaction, values);
        for (Variable variable : this.context.values()) {
            variable.valueSynchronized();
        }
    }

    public Map<String, Object> getValuesToSynchronize() {
        HashMap values = Maps.newHashMap();
        for (Variable variable : this.context.values()) {
            if (!variable.hasPhantomValue()) continue;
            values.put(variable.getId(), variable.getValueAsBasicType());
        }
        return values;
    }
}

