/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.DeactivationActivity;
import com.suncode.pwfl.administration.user.DeactivationParticipant;
import com.suncode.pwfl.administration.user.DeactivationProcess;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.assignment.WfParticipant;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deactivation {
    private static final Logger log = LoggerFactory.getLogger(Deactivation.class);
    private User user;
    private User substitutionUser;
    private User viewUser;
    private User reportUser;
    private User notificationUser;
    private User otherAcitivitiesUser;
    private User favouriteSetsUser;
    private boolean skipSubstitutions = false;
    private boolean skipNotifications = false;
    private Boolean runInBackground;
    private Map<String, User> extraTransfers = new HashMap<String, User>();
    private List<DeactivationProcess> processes;
    private List<User> defaultUsers = new ArrayList<User>();

    public static Deactivation create(String userName) {
        Deactivation deactivation = new Deactivation();
        UserService us = SpringContext.getBean(UserService.class);
        User user = us.getUser(userName, new String[0]);
        Deactivation.validateUser(user);
        deactivation.setUser(user);
        ProcessService ps = SpringContext.getBean(ProcessService.class);
        List<ProcessType> procTypes = ps.getAllProcessTypes(true);
        ArrayList<DeactivationProcess> procs = new ArrayList<DeactivationProcess>();
        for (ProcessType processType : procTypes) {
            DeactivationProcess dp = new DeactivationProcess(processType);
            List<WfParticipant> parts = ps.getParticipantsFromProcess(dp.getProcessDefId());
            List<DeactivationParticipant> dParts = Deactivation.convertToParticipants(userName, dp.getProcessDefId(), parts);
            dp.setParticipants(dParts);
            procs.add(dp);
        }
        deactivation.setProcesses(procs);
        Deactivation.setDefaultUsers(deactivation, us);
        return deactivation;
    }

    public static Deactivation create(String userName, List<DeactivationProcess> processes) {
        Deactivation deactivation = new Deactivation();
        UserService us = SpringContext.getBean(UserService.class);
        User user = us.getUser(userName, new String[0]);
        Deactivation.validateUser(user);
        deactivation.setUser(user);
        deactivation.setProcesses(processes);
        Deactivation.setDefaultUsers(deactivation, us);
        return deactivation;
    }

    private static void validateUser(User user) throws IllegalArgumentException {
        if (user == null) {
            throw new IllegalArgumentException("User to deactivate doesn't exist.");
        }
        String userName = user.getUserName();
        if (Deactivation.isEmptyTaskUserNameOrAdmin(userName)) {
            throw new IllegalArgumentException(userName + " is admin or is specified in EmptyTaskUserName parameter ");
        }
    }

    public static boolean isEmptyTaskUserNameOrAdmin(String username) {
        ArrayList<String> emptyTaskUserNamesOrAdmin = new ArrayList<String>();
        emptyTaskUserNamesOrAdmin.add("admin");
        String emptyTaskUserName = SystemProperties.getString(DefinedSystemParameter.EMPTY_TASK_USER_NAME);
        if (StringUtils.isNotBlank((String)emptyTaskUserName)) {
            emptyTaskUserNamesOrAdmin.addAll(Arrays.asList(emptyTaskUserName.split(";")));
        }
        return emptyTaskUserNamesOrAdmin.contains(username);
    }

    private static List<DeactivationParticipant> convertToParticipants(String userName, String processDefId, List<WfParticipant> parts) {
        ProcessService ps = SpringContext.getBean(ProcessService.class);
        Map<String, List<ActivityType>> acts = ps.getRoleActivityMap(processDefId);
        ArrayList<DeactivationParticipant> dps = new ArrayList<DeactivationParticipant>();
        for (WfParticipant wfParticipant : parts) {
            DeactivationParticipant dp = new DeactivationParticipant(wfParticipant);
            List<DeactivationActivity> da = Deactivation.convertToActivities(userName, processDefId, acts.get(wfParticipant.getId()));
            dp.setActivities(da);
            dps.add(dp);
        }
        return dps;
    }

    private static List<DeactivationActivity> convertToActivities(String userName, String processDefId, List<ActivityType> acts) {
        ArrayList<DeactivationActivity> list = new ArrayList<DeactivationActivity>();
        for (ActivityType at : acts) {
            boolean assing = Deactivation.doesUserAssignToActivity(userName, processDefId, at.getActivityDefId());
            DeactivationActivity atd = new DeactivationActivity(at, assing);
            list.add(atd);
        }
        return list;
    }

    private static boolean doesUserAssignToActivity(String userName, String processDefId, String activityDefId) {
        AssignmentService as = SpringContext.getBean(AssignmentService.class);
        List<Map<String, Object>> list = as.getAssignments(processDefId, activityDefId, userName);
        return !list.isEmpty();
    }

    private static void setDefaultUsers(Deactivation deactivation, UserService us) {
        String[] usersName;
        String defaultUserName = "admin";
        ArrayList<User> users = new ArrayList<User>();
        String emptyTaskUsersName = SystemProperties.getString(DefinedSystemParameter.EMPTY_TASK_USER_NAME);
        if (StringUtils.isBlank((String)emptyTaskUsersName)) {
            emptyTaskUsersName = defaultUserName;
        }
        for (String userName : usersName = emptyTaskUsersName.split(";")) {
            if (!StringUtils.equals((String)userName, (String)deactivation.getUser().getUserName())) {
                User u = us.getUser(userName, new String[0]);
                if (u != null) {
                    users.add(u);
                    continue;
                }
                log.warn("U\u017cytkownik '{}' podany w parametrze emptyTaskUserName nie istnieje w systemie. Pomijam.", (Object)userName);
                continue;
            }
            log.warn("U\u017cytkownik '{}' podany w parametrze emptyTaskUserName jest u\u017cytkownikiem, kt\u00f3rego dezaktywujemy. Pomijam.", (Object)userName);
        }
        deactivation.setDefaultUsers(users);
    }

    public List<DeactivationProcess> getProcesses() {
        return this.processes;
    }

    private void setProcesses(List<DeactivationProcess> processes) {
        this.processes = processes;
    }

    public List<User> getDefaultUsers() {
        return this.defaultUsers;
    }

    private void setDefaultUsers(List<User> defaultUsers) {
        this.defaultUsers = defaultUsers;
    }

    public void setUsers(List<User> users) {
        for (DeactivationProcess process : this.processes) {
            List<DeactivationParticipant> participants = process.getParticipants();
            for (DeactivationParticipant participant : participants) {
                List<DeactivationActivity> activities = participant.getActivities();
                for (DeactivationActivity activity : activities) {
                    activity.setUsers(users);
                }
            }
        }
    }

    public void setGroups(List<UserGroup> groups) {
        for (DeactivationProcess process : this.processes) {
            List<DeactivationParticipant> participants = process.getParticipants();
            for (DeactivationParticipant participant : participants) {
                List<DeactivationActivity> activities = participant.getActivities();
                for (DeactivationActivity activity : activities) {
                    activity.setGroups(groups);
                }
            }
        }
    }

    public Boolean getRunInBackground() {
        return this.runInBackground != null ? this.runInBackground : false;
    }

    public void setRunInBackground(Boolean runInBackground) {
        this.runInBackground = runInBackground != null ? runInBackground : false;
    }

    public User getUser() {
        return this.user;
    }

    public User getSubstitutionUser() {
        return this.substitutionUser;
    }

    public User getViewUser() {
        return this.viewUser;
    }

    public User getReportUser() {
        return this.reportUser;
    }

    public User getNotificationUser() {
        return this.notificationUser;
    }

    public User getOtherAcitivitiesUser() {
        return this.otherAcitivitiesUser;
    }

    public User getFavouriteSetsUser() {
        return this.favouriteSetsUser;
    }

    public boolean isSkipSubstitutions() {
        return this.skipSubstitutions;
    }

    public boolean isSkipNotifications() {
        return this.skipNotifications;
    }

    public Map<String, User> getExtraTransfers() {
        return this.extraTransfers;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setSubstitutionUser(User substitutionUser) {
        this.substitutionUser = substitutionUser;
    }

    public void setViewUser(User viewUser) {
        this.viewUser = viewUser;
    }

    public void setReportUser(User reportUser) {
        this.reportUser = reportUser;
    }

    public void setNotificationUser(User notificationUser) {
        this.notificationUser = notificationUser;
    }

    public void setOtherAcitivitiesUser(User otherAcitivitiesUser) {
        this.otherAcitivitiesUser = otherAcitivitiesUser;
    }

    public void setFavouriteSetsUser(User favouriteSetsUser) {
        this.favouriteSetsUser = favouriteSetsUser;
    }

    public void setSkipSubstitutions(boolean skipSubstitutions) {
        this.skipSubstitutions = skipSubstitutions;
    }

    public void setSkipNotifications(boolean skipNotifications) {
        this.skipNotifications = skipNotifications;
    }

    public void setExtraTransfers(Map<String, User> extraTransfers) {
        this.extraTransfers = extraTransfers;
    }

    private Deactivation() {
    }
}

