/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.validator;

import com.google.common.collect.Sets;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.InvocableComponent;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinition;
import com.suncode.pwfl.workflow.form.validator.ValidatorMessage;
import com.suncode.pwfl.workflow.form.validator.error.ValidationError;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
extends InvocableComponent {
    public static final String VALIDATE_METHOD_NAME = "validate";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ValidatorMessage> messageTypes = Sets.newHashSet();

    public Validator(ComponentDefinition definition, Method validateMethod, Object instance) {
        super(definition, validateMethod, instance);
        if (definition instanceof ValidatorDefinition) {
            ValidatorDefinition validatorDefinition = (ValidatorDefinition)definition;
            this.messageTypes.addAll(validatorDefinition.getMessageTypes());
        }
    }

    @Override
    public void invoke(Parameters parameters, ActivityContextMap contextMap, ContextVariables contextVariables) {
        ValidationContext context = ValidationContext.current();
        super.invoke(parameters, context, context.getValidationErrors(), contextMap, contextVariables, context.getConfirmation(), context.getError());
        this.logErrors(context.getValidationErrors().getErrors(this.getId()));
        this.logCallbacks(context.getValidationErrors());
    }

    private void logErrors(List<ValidationError> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            this.logger.info("Validator[{}] does not report any errors.", (Object)this.getId());
        } else {
            StringBuilder sb = new StringBuilder();
            for (ValidationError error : errors) {
                sb.append("[").append(error.getMessage()).append("] ");
            }
            this.logger.info("Validator[{}] reports {} errors: {}", new Object[]{this.getId(), errors.size(), sb.toString()});
        }
    }

    private void logCallbacks(ValidationErrors validationErrors) {
        if (validationErrors.hasInvokedCallback(this.getId()).booleanValue()) {
            this.logger.info("Validator [{}] invoked callback", (Object)this.getId());
        }
    }

    public Set<ValidatorMessage> getMessageTypes() {
        return this.messageTypes;
    }
}

