/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util.style;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

public class IconUtils {
    private static Map<String, List<String>> dvntIconToSilkIcons = ImmutableMap.builder().put((Object)"attachment", Arrays.asList("attach", "email_attach", "page_attach")).put((Object)"arrow-branch", Arrays.asList("arrow_branch")).put((Object)"arrow-divide", Arrays.asList("arrow_divide")).put((Object)"book-next", Arrays.asList("book_next")).put((Object)"book-open", Arrays.asList("book_open")).put((Object)"calculator", Arrays.asList("calculator")).put((Object)"door-in", Arrays.asList("door_in")).put((Object)"door-open", Arrays.asList("door_open")).put((Object)"folder-note", Arrays.asList("folder_page", "folder_page_white")).put((Object)"money", Arrays.asList("money")).put((Object)"pause", Arrays.asList("control_pause")).put((Object)"rename", Arrays.asList("textfield_rename")).put((Object)"word", Arrays.asList("page_white_word")).put((Object)"book", Arrays.asList("book_add")).put((Object)"check-circle", Arrays.asList("accept")).put((Object)"check-symbol", Arrays.asList("spellcheck", "tick")).put((Object)"chevron-double-right", Arrays.asList("control_fastforward")).put((Object)"chevron-right", Arrays.asList("resultset_next")).put((Object)"clock", Arrays.asList("clock")).put((Object)"conversation", Arrays.asList("comment", "user_comment")).put((Object)"copy", Arrays.asList("page_copy")).put((Object)"database", Arrays.asList("database_add")).put((Object)"delete2", Arrays.asList("bin")).put((Object)"document2", Arrays.asList("page_white_text")).put((Object)"down-left", Arrays.asList("arrow_undo")).put((Object)"down-right", Arrays.asList("arrow_redo")).put((Object)"down-straight", Arrays.asList("application_put", "arrow_down", "page_white_put")).put((Object)"edit", Arrays.asList("application_edit", "application_form_edit", "clock_edit", "comment_edit", "pencil", "user_edit")).put((Object)"edit-form", Arrays.asList("page_edit", "book_edit")).put((Object)"exclamation-circle", Arrays.asList("bug")).put((Object)"exclamation-triangle", Arrays.asList("calculator_error", "error_go")).put((Object)"file", Arrays.asList("page", "page_white")).put((Object)"file-minus", Arrays.asList("page_white_delete", "page_delete")).put((Object)"file-plus", Arrays.asList("page_add")).put((Object)"folder-plus", Arrays.asList("folder_add")).put((Object)"globe", Arrays.asList("world_go")).put((Object)"info-circle", Arrays.asList("information")).put((Object)"left-straight", Arrays.asList("arrow_left")).put((Object)"list2", Arrays.asList("text_list_numbers")).put((Object)"locked", Arrays.asList("anchor", "application_key")).put((Object)"mail2", Arrays.asList("email-active-success")).put((Object)"maximize2", Arrays.asList("arrow_out")).put((Object)"minimize2", Arrays.asList("arrow_inout")).put((Object)"minus-circle", Arrays.asList("application_delete", "application_form_delete", "delete")).put((Object)"pdf", Arrays.asList("page_white_acrobat")).put((Object)"pen-tool", Arrays.asList("pencil")).put((Object)"plus-circle", Arrays.asList("add", "calculator_add", "coins_add", "comment_add", "email_add", "money_add", "time_add", "user_add")).put((Object)"printer2", Arrays.asList("printer")).put((Object)"radiobutton-unchecked-error", Arrays.asList("bullet_delete")).put((Object)"refresh", Arrays.asList("arrow_refresh", "database_refresh")).put((Object)"report", Arrays.asList("report")).put((Object)"right-straight", Arrays.asList("application_go", "arrow_right", "book_go", "database_go", "package_go", "page_go", "pencil_go", "transmit_go", "user_go")).put((Object)"rotation-left", Arrays.asList("arrow_rotate_clockwise")).put((Object)"rotation-right", Arrays.asList("arrow_rotate_anticlockwise")).put((Object)"save", Arrays.asList("page_save", "bullet_disk")).put((Object)"scissors-tool", Arrays.asList("cut")).put((Object)"search", Arrays.asList("find", "magnifier")).put((Object)"send", Arrays.asList("email_go")).put((Object)"settings", Arrays.asList("bullet_wrench", "cog")).put((Object)"shop", Arrays.asList("basket")).put((Object)"star", Arrays.asList("thumb_up")).put((Object)"stop-symbol", Arrays.asList("bullet_delete")).put((Object)"time", Arrays.asList("bomb")).put((Object)"underscore-circle", Arrays.asList("help")).put((Object)"up-left", Arrays.asList("arrow_turn_left")).put((Object)"up-right", Arrays.asList("arrow_turn_right")).put((Object)"up-straight", Arrays.asList("application_get", "arrow_up")).put((Object)"user", Arrays.asList("user_green", "user_orange", "user_suit")).put((Object)"users", Arrays.asList("group_go")).put((Object)"windows", Arrays.asList("layout", "application")).put((Object)"x-circle", Arrays.asList("cancel")).put((Object)"x-octagon", Arrays.asList("stop")).put((Object)"x-square", Arrays.asList("cross")).put((Object)"zoom-in", Arrays.asList("zoom")).put((Object)"zoom-out", Arrays.asList("zoom")).put((Object)"table", Arrays.asList("table")).put((Object)"table-go", Arrays.asList("table_go")).put((Object)"table-relationship", Arrays.asList("table_relationship")).put((Object)"table-add", Arrays.asList("table_add")).put((Object)"table-key", Arrays.asList("table_key")).put((Object)"table-row-delete", Arrays.asList("table_row_delete")).put((Object)"table-delete", Arrays.asList("table_delete")).put((Object)"table-lightning", Arrays.asList("table_lightning")).put((Object)"table-row-insert", Arrays.asList("table_row_insert")).put((Object)"table-edit", Arrays.asList("table_edit")).put((Object)"table-sort1", Arrays.asList("table_link")).put((Object)"table-save", Arrays.asList("table_save")).put((Object)"table-error", Arrays.asList("table_error")).put((Object)"table-multiple", Arrays.asList("table_multiple")).put((Object)"table-sort", Arrays.asList("table_sort")).put((Object)"table-gear", Arrays.asList("table_gear")).put((Object)"table-refresh", Arrays.asList("table_refresh")).build();
    private static final String DEFAULT_ICON = "exclamation-circle";
    private static final String DIVANTE_ICON_PREFIX = "DIVANTE_ICON_";

    public static String resolveTargetIcon(String rawIcon) {
        if (IconUtils.isDivanteIcon(rawIcon)) {
            return IconUtils.toDivanteClass(rawIcon);
        }
        return IconUtils.wrapDvntPrefix(IconUtils.resolveIcon(rawIcon));
    }

    public static String resolveIcon(String silkIconUrl) {
        return IconUtils.toDvntIcon(silkIconUrl).orElseGet(() -> DEFAULT_ICON);
    }

    public static String addClsPrefix(String iconName) {
        return IconUtils.wrapDvntPrefix(iconName);
    }

    private static Optional<String> toDvntIcon(String silkIconUrl) {
        String silkIconName = IconUtils.resolveIconName(silkIconUrl);
        return IconUtils.toDvntIconFromSilkName(silkIconName);
    }

    private static String resolveIconName(String silkIconUrl) {
        return FilenameUtils.getBaseName((String)silkIconUrl);
    }

    private static Optional<String> toDvntIconFromSilkName(String silkIconName) {
        return dvntIconToSilkIcons.entrySet().stream().filter(entry -> {
            List silkIcons = (List)entry.getValue();
            return silkIcons.contains(silkIconName);
        }).map(Map.Entry::getKey).findFirst();
    }

    private static String wrapDvntPrefix(String iconName) {
        return "dvnt-icon-" + iconName;
    }

    private static boolean isDivanteIcon(String rawIcon) {
        return rawIcon.startsWith(DIVANTE_ICON_PREFIX);
    }

    private static String toDivanteClass(String rawIcon) {
        return IconUtils.wrapDvntPrefix(rawIcon.replaceFirst(DIVANTE_ICON_PREFIX, ""));
    }
}

