/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum DivanteColor {
    ORANGE("orange"),
    ORANGE_PALE("orange-pale"),
    BLUE("blue"),
    BLUE_ACTIVE("blue-active"),
    GRAY_PALE("gray-pale"),
    WHITE("white"),
    RED("red"),
    GREEN("green"),
    BLUE_PALE("blue-pale"),
    TABLE_BLACK("table-black"),
    TABLE_BLACK_ACTIVE("table-black-active"),
    TABLE_GRAY("table-gray"),
    DARK_BLUE("dark-blue"),
    GRAY("gray"),
    ICON_GRAY("icon-gray"),
    TABLE_TEXT_GRAY("table-text-gray"),
    ORANGE_DIM("orange-dim"),
    PURPLE_PALE("purple-pale"),
    PURPLE_DIM("purple-dim"),
    BLUE_PASTEL("blue-pastel"),
    BLUE_DIM("blue-dim"),
    YELLOW("yellow"),
    YELLOW_PALE("yellow-pale"),
    YELLOW_DIM("yellow-dim"),
    GREEN_PALE("green-pale"),
    GREEN_DIM("green-dim"),
    PINK("pink"),
    PINK_PALE("pink-pale"),
    PINK_DIM("pink-dim"),
    BLUE_GREY("blue-grey"),
    BLUE_GREY_PALE("blue-grey-pale");

    private static final List<DivanteColor> colorsExcludedFromAvatar;
    private String code;

    private DivanteColor(String code) {
        this.code = code;
    }

    public static DivanteColor fromString(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        return DivanteColor.valueOf(text.trim().toUpperCase());
    }

    public static DivanteColor fromCode(String code) {
        return Stream.of(DivanteColor.values()).filter(icon -> icon.code.equals(code)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static List<DivanteColor> getColorsForAvatar() {
        return Arrays.stream(DivanteColor.values()).filter(divanteColor -> !colorsExcludedFromAvatar.contains(divanteColor)).collect(Collectors.toList());
    }

    public String getCode() {
        return this.code;
    }

    static {
        colorsExcludedFromAvatar = Arrays.asList(WHITE, TABLE_BLACK, TABLE_BLACK_ACTIVE);
    }
}

