/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email;

import com.suncode.pwfl.administration.email.EmailAttachment;
import com.suncode.pwfl.administration.email.EmailInfo;
import com.suncode.pwfl.archive.WfDocument;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EmailMessage {
    private List<String> recipients;
    private List<String> copyRecipients;
    private List<String> hiddenCopyRecipients;
    private String subject;
    private String content;
    private boolean isHtml;
    private List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
    private EmailInfo emailInfo;
    private boolean test;
    private Map<String, String> params;
    private InputStream templateInputStream;
    private File template;

    public String toString() {
        return "EmailMessage{recipients=" + this.recipients + ", copyRecipients=" + this.copyRecipients + ", hiddenCopyRecipients=" + this.hiddenCopyRecipients + ", subject='" + this.subject + '\'' + ", isHtml=" + this.isHtml + ", attachments=" + this.attachments + ", emailInfo=" + this.emailInfo + ", test=" + this.test + ", params=" + this.params + ", template=" + this.templateInputStream + '}';
    }

    public static EmailMessageBuilder builder() {
        return new EmailMessageBuilder();
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public List<String> getCopyRecipients() {
        return this.copyRecipients;
    }

    public List<String> getHiddenCopyRecipients() {
        return this.hiddenCopyRecipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isHtml() {
        return this.isHtml;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public EmailInfo getEmailInfo() {
        return this.emailInfo;
    }

    public boolean isTest() {
        return this.test;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public File getTemplate() {
        return this.template;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public void setCopyRecipients(List<String> copyRecipients) {
        this.copyRecipients = copyRecipients;
    }

    public void setHiddenCopyRecipients(List<String> hiddenCopyRecipients) {
        this.hiddenCopyRecipients = hiddenCopyRecipients;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setHtml(boolean isHtml) {
        this.isHtml = isHtml;
    }

    public void setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
    }

    public void setEmailInfo(EmailInfo emailInfo) {
        this.emailInfo = emailInfo;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public EmailMessage() {
    }

    @ConstructorProperties(value={"recipients", "copyRecipients", "hiddenCopyRecipients", "subject", "content", "isHtml", "attachments", "emailInfo", "test", "params", "templateInputStream", "template"})
    public EmailMessage(List<String> recipients, List<String> copyRecipients, List<String> hiddenCopyRecipients, String subject, String content, boolean isHtml, List<EmailAttachment> attachments, EmailInfo emailInfo, boolean test, Map<String, String> params, InputStream templateInputStream, File template) {
        this.recipients = recipients;
        this.copyRecipients = copyRecipients;
        this.hiddenCopyRecipients = hiddenCopyRecipients;
        this.subject = subject;
        this.content = content;
        this.isHtml = isHtml;
        this.attachments = attachments;
        this.emailInfo = emailInfo;
        this.test = test;
        this.params = params;
        this.templateInputStream = templateInputStream;
        this.template = template;
    }

    public static class EmailMessageBuilder {
        private ArrayList<String> recipients;
        private ArrayList<String> copyRecipients;
        private ArrayList<String> hiddenCopyRecipients;
        private String subject;
        private String content;
        private boolean isHtml;
        private ArrayList<EmailAttachment> attachments;
        private EmailInfo emailInfo;
        private boolean test;
        private Map<String, String> params;
        private InputStream templateInputStream;
        private File template;

        public EmailMessageBuilder documents(List<WfDocument> documents) {
            if (documents == null) {
                return this;
            }
            List attachments = documents.stream().map(EmailAttachment::new).collect(Collectors.toList());
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        EmailMessageBuilder() {
        }

        public EmailMessageBuilder recipient(String recipient) {
            if (this.recipients == null) {
                this.recipients = new ArrayList();
            }
            this.recipients.add(recipient);
            return this;
        }

        public EmailMessageBuilder recipients(Collection<? extends String> recipients) {
            if (this.recipients == null) {
                this.recipients = new ArrayList();
            }
            this.recipients.addAll(recipients);
            return this;
        }

        public EmailMessageBuilder clearRecipients() {
            if (this.recipients != null) {
                this.recipients.clear();
            }
            return this;
        }

        public EmailMessageBuilder copyRecipient(String copyRecipient) {
            if (this.copyRecipients == null) {
                this.copyRecipients = new ArrayList();
            }
            this.copyRecipients.add(copyRecipient);
            return this;
        }

        public EmailMessageBuilder copyRecipients(Collection<? extends String> copyRecipients) {
            if (this.copyRecipients == null) {
                this.copyRecipients = new ArrayList();
            }
            this.copyRecipients.addAll(copyRecipients);
            return this;
        }

        public EmailMessageBuilder clearCopyRecipients() {
            if (this.copyRecipients != null) {
                this.copyRecipients.clear();
            }
            return this;
        }

        public EmailMessageBuilder hiddenCopyRecipient(String hiddenCopyRecipient) {
            if (this.hiddenCopyRecipients == null) {
                this.hiddenCopyRecipients = new ArrayList();
            }
            this.hiddenCopyRecipients.add(hiddenCopyRecipient);
            return this;
        }

        public EmailMessageBuilder hiddenCopyRecipients(Collection<? extends String> hiddenCopyRecipients) {
            if (this.hiddenCopyRecipients == null) {
                this.hiddenCopyRecipients = new ArrayList();
            }
            this.hiddenCopyRecipients.addAll(hiddenCopyRecipients);
            return this;
        }

        public EmailMessageBuilder clearHiddenCopyRecipients() {
            if (this.hiddenCopyRecipients != null) {
                this.hiddenCopyRecipients.clear();
            }
            return this;
        }

        public EmailMessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public EmailMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public EmailMessageBuilder isHtml(boolean isHtml) {
            this.isHtml = isHtml;
            return this;
        }

        public EmailMessageBuilder attachment(EmailAttachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public EmailMessageBuilder attachments(Collection<? extends EmailAttachment> attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public EmailMessageBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public EmailMessageBuilder emailInfo(EmailInfo emailInfo) {
            this.emailInfo = emailInfo;
            return this;
        }

        public EmailMessageBuilder test(boolean test) {
            this.test = test;
            return this;
        }

        public EmailMessageBuilder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public EmailMessageBuilder templateInputStream(InputStream templateInputStream) {
            this.templateInputStream = templateInputStream;
            return this;
        }

        public EmailMessageBuilder template(File template) {
            this.template = template;
            return this;
        }

        public EmailMessage build() {
            List<EmailAttachment> attachments;
            List<String> hiddenCopyRecipients;
            List<String> copyRecipients;
            List<String> recipients;
            switch (this.recipients == null ? 0 : this.recipients.size()) {
                case 0: {
                    recipients = Collections.emptyList();
                    break;
                }
                case 1: {
                    recipients = Collections.singletonList(this.recipients.get(0));
                    break;
                }
                default: {
                    recipients = Collections.unmodifiableList(new ArrayList<String>(this.recipients));
                }
            }
            switch (this.copyRecipients == null ? 0 : this.copyRecipients.size()) {
                case 0: {
                    copyRecipients = Collections.emptyList();
                    break;
                }
                case 1: {
                    copyRecipients = Collections.singletonList(this.copyRecipients.get(0));
                    break;
                }
                default: {
                    copyRecipients = Collections.unmodifiableList(new ArrayList<String>(this.copyRecipients));
                }
            }
            switch (this.hiddenCopyRecipients == null ? 0 : this.hiddenCopyRecipients.size()) {
                case 0: {
                    hiddenCopyRecipients = Collections.emptyList();
                    break;
                }
                case 1: {
                    hiddenCopyRecipients = Collections.singletonList(this.hiddenCopyRecipients.get(0));
                    break;
                }
                default: {
                    hiddenCopyRecipients = Collections.unmodifiableList(new ArrayList<String>(this.hiddenCopyRecipients));
                }
            }
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<EmailAttachment>(this.attachments));
                }
            }
            return new EmailMessage(recipients, copyRecipients, hiddenCopyRecipients, this.subject, this.content, this.isHtml, attachments, this.emailInfo, this.test, this.params, this.templateInputStream, this.template);
        }

        public String toString() {
            return "EmailMessage.EmailMessageBuilder(recipients=" + this.recipients + ", copyRecipients=" + this.copyRecipients + ", hiddenCopyRecipients=" + this.hiddenCopyRecipients + ", subject=" + this.subject + ", content=" + this.content + ", isHtml=" + this.isHtml + ", attachments=" + this.attachments + ", emailInfo=" + this.emailInfo + ", test=" + this.test + ", params=" + this.params + ", templateInputStream=" + this.templateInputStream + ", template=" + this.template + ")";
        }
    }
}

