/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.persistence.support.hibernate.EntityEventListener;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SpringContext;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@EntityEventListener(value={"post-commit-update"})
public class UserInfoCache
extends CacheLoader<String, UserInfo>
implements PostUpdateEventListener {
    private final UserService userService;
    private final LoadingCache<String, UserInfo> cache = CacheBuilder.newBuilder().maximumSize(2000L).refreshAfterWrite(8L, TimeUnit.HOURS).build((CacheLoader)this);

    @Autowired
    public UserInfoCache(UserService userService) {
        Assert.notNull((Object)userService);
        this.userService = userService;
    }

    public static UserInfoCache get() {
        return SpringContext.getBean(UserInfoCache.class);
    }

    public UserInfo get(String user) {
        return (UserInfo)this.cache.getUnchecked((Object)user);
    }

    public void clear(String ... users) {
        this.cache.invalidateAll(Arrays.asList(users));
    }

    public void clearAll() {
        this.cache.invalidateAll();
    }

    public UserInfo load(String key) throws Exception {
        User user = TransactionWrapper.get().doInHibernateTransaction(session -> this.userService.getUser(key, "groups", "positions.organizationalUnit", "positions", "positions.higherPosition", "positions.higherPosition.user"));
        if (user != null) {
            return new UserInfo(user);
        }
        throw new UserNotFoundException(key);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        Class<?> entityClass = entity.getClass();
        if (entityClass == User.class) {
            this.clear(((User)entity).getUserName());
        } else if (entityClass == Position.class) {
            this.clearAll();
        } else if (entityClass == OrganizationalUnit.class) {
            this.clearAll();
        }
    }
}

