/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.suncode.pwfl.core.type.support.JsonTypeBase;

public class StringType
extends JsonTypeBase<String> {
    private static final String defaultValue = "";
    public static final StringType INSTANCE = new StringType();

    private StringType() {
        super(String.class, defaultValue);
    }

    @Override
    public String name() {
        return "string";
    }

    @Override
    public String translationKey() {
        return "Tekstowy";
    }

    @Override
    protected JsonNode serializeNonNullValue(String value) {
        return TextNode.valueOf((String)value);
    }

    @Override
    protected String deserializeNonEmptyNode(JsonNode json) {
        return json.asText();
    }

    @Override
    protected boolean isNodeEmpty(JsonNode json) {
        return json == null || json.isNull();
    }

    @Override
    public String convert(String value) {
        return value;
    }
}

