/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email.configuration;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import com.suncode.pwfl.administration.email.configuration.EmailAuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import java.beans.ConstructorProperties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_email_config")
@SequenceGenerator(name="pm_email_config_id_seq", sequenceName="pm_email_config_id_seq")
public class EmailConfiguration {
    public static final String JOIN_CONNECTION = "oauth2Connection";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_email_config_id_seq")
    private Long id;
    private String name;
    @Column(length=512)
    private String email;
    @Column(nullable=false)
    private Boolean defaultConfiguration;
    @Column(length=512)
    private String mailServer;
    @Column(length=512)
    private String smtpMailServer;
    @Column(nullable=false)
    private Integer smtpPortNumber = 0;
    private String sourceAddress;
    @Column(nullable=false)
    private Integer timeout = 30000;
    @Column(length=512)
    private String mailUser;
    @Column(nullable=false)
    private Boolean useSSL;
    @Column(nullable=false)
    private Boolean useStartTLS;
    @Column(length=512)
    private String smtpUser;
    @Column(length=512)
    private String userPassword;
    @Column(nullable=false)
    private Boolean debug;
    @Enumerated(value=EnumType.STRING)
    private EmailAuthenticationMethod emailAuthenticationMethod = EmailAuthenticationMethod.NONE;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oauthconnection")
    private OAuth2Connection oauth2Connection;
    @Column(nullable=false)
    private Boolean bufferedSender = false;
    @Column(nullable=false)
    private Integer maxAttempts = 5;
    @Column(nullable=false)
    private Integer period = 10000;
    @Column(nullable=false)
    private Integer tryAfter = 20000;

    public String getDecryptedUserPassword() {
        if (StringUtils.isNotEmpty((CharSequence)this.userPassword)) {
            try {
                return TextCipher.decrypt(this.userPassword);
            }
            catch (Exception e) {
                throw new DecryptingException();
            }
        }
        return this.userPassword;
    }

    public void setEncryptedUserPassword(String userPassword) {
        if (StringUtils.isNotEmpty((CharSequence)userPassword)) {
            try {
                this.userPassword = TextCipher.encrypt(userPassword);
            }
            catch (Exception e) {
                throw new EncryptingException();
            }
        } else {
            this.userPassword = userPassword;
        }
    }

    public static EmailConfigurationBuilder builder() {
        return new EmailConfigurationBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public String getSmtpMailServer() {
        return this.smtpMailServer;
    }

    public Integer getSmtpPortNumber() {
        return this.smtpPortNumber;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getMailUser() {
        return this.mailUser;
    }

    public Boolean getUseSSL() {
        return this.useSSL;
    }

    public Boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public EmailAuthenticationMethod getEmailAuthenticationMethod() {
        return this.emailAuthenticationMethod;
    }

    public OAuth2Connection getOauth2Connection() {
        return this.oauth2Connection;
    }

    public Boolean getBufferedSender() {
        return this.bufferedSender;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Integer getTryAfter() {
        return this.tryAfter;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setDefaultConfiguration(Boolean defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    public void setSmtpMailServer(String smtpMailServer) {
        this.smtpMailServer = smtpMailServer;
    }

    public void setSmtpPortNumber(Integer smtpPortNumber) {
        this.smtpPortNumber = smtpPortNumber;
    }

    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMailUser(String mailUser) {
        this.mailUser = mailUser;
    }

    public void setUseSSL(Boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setUseStartTLS(Boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public void setEmailAuthenticationMethod(EmailAuthenticationMethod emailAuthenticationMethod) {
        this.emailAuthenticationMethod = emailAuthenticationMethod;
    }

    public void setOauth2Connection(OAuth2Connection oauth2Connection) {
        this.oauth2Connection = oauth2Connection;
    }

    public void setBufferedSender(Boolean bufferedSender) {
        this.bufferedSender = bufferedSender;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public void setTryAfter(Integer tryAfter) {
        this.tryAfter = tryAfter;
    }

    public EmailConfiguration() {
    }

    @ConstructorProperties(value={"id", "name", "email", "defaultConfiguration", "mailServer", "smtpMailServer", "smtpPortNumber", "sourceAddress", "timeout", "mailUser", "useSSL", "useStartTLS", "smtpUser", "userPassword", "debug", "emailAuthenticationMethod", "oauth2Connection", "bufferedSender", "maxAttempts", "period", "tryAfter"})
    public EmailConfiguration(Long id, String name, String email, Boolean defaultConfiguration, String mailServer, String smtpMailServer, Integer smtpPortNumber, String sourceAddress, Integer timeout, String mailUser, Boolean useSSL, Boolean useStartTLS, String smtpUser, String userPassword, Boolean debug, EmailAuthenticationMethod emailAuthenticationMethod, OAuth2Connection oauth2Connection, Boolean bufferedSender, Integer maxAttempts, Integer period, Integer tryAfter) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.defaultConfiguration = defaultConfiguration;
        this.mailServer = mailServer;
        this.smtpMailServer = smtpMailServer;
        this.smtpPortNumber = smtpPortNumber;
        this.sourceAddress = sourceAddress;
        this.timeout = timeout;
        this.mailUser = mailUser;
        this.useSSL = useSSL;
        this.useStartTLS = useStartTLS;
        this.smtpUser = smtpUser;
        this.userPassword = userPassword;
        this.debug = debug;
        this.emailAuthenticationMethod = emailAuthenticationMethod;
        this.oauth2Connection = oauth2Connection;
        this.bufferedSender = bufferedSender;
        this.maxAttempts = maxAttempts;
        this.period = period;
        this.tryAfter = tryAfter;
    }

    public static class EmailConfigurationBuilder {
        private Long id;
        private String name;
        private String email;
        private Boolean defaultConfiguration;
        private String mailServer;
        private String smtpMailServer;
        private Integer smtpPortNumber;
        private String sourceAddress;
        private Integer timeout;
        private String mailUser;
        private Boolean useSSL;
        private Boolean useStartTLS;
        private String smtpUser;
        private String userPassword;
        private Boolean debug;
        private EmailAuthenticationMethod emailAuthenticationMethod;
        private OAuth2Connection oauth2Connection;
        private Boolean bufferedSender;
        private Integer maxAttempts;
        private Integer period;
        private Integer tryAfter;

        public EmailConfigurationBuilder encryptedUserPassword(String userPassword) {
            if (StringUtils.isNotEmpty((CharSequence)userPassword)) {
                try {
                    this.userPassword = TextCipher.encrypt(userPassword);
                }
                catch (Exception e) {
                    throw new EncryptingException();
                }
            } else {
                this.userPassword = userPassword;
            }
            return this;
        }

        EmailConfigurationBuilder() {
        }

        public EmailConfigurationBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public EmailConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EmailConfigurationBuilder email(String email) {
            this.email = email;
            return this;
        }

        public EmailConfigurationBuilder defaultConfiguration(Boolean defaultConfiguration) {
            this.defaultConfiguration = defaultConfiguration;
            return this;
        }

        public EmailConfigurationBuilder mailServer(String mailServer) {
            this.mailServer = mailServer;
            return this;
        }

        public EmailConfigurationBuilder smtpMailServer(String smtpMailServer) {
            this.smtpMailServer = smtpMailServer;
            return this;
        }

        public EmailConfigurationBuilder smtpPortNumber(Integer smtpPortNumber) {
            this.smtpPortNumber = smtpPortNumber;
            return this;
        }

        public EmailConfigurationBuilder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public EmailConfigurationBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public EmailConfigurationBuilder mailUser(String mailUser) {
            this.mailUser = mailUser;
            return this;
        }

        public EmailConfigurationBuilder useSSL(Boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public EmailConfigurationBuilder useStartTLS(Boolean useStartTLS) {
            this.useStartTLS = useStartTLS;
            return this;
        }

        public EmailConfigurationBuilder smtpUser(String smtpUser) {
            this.smtpUser = smtpUser;
            return this;
        }

        public EmailConfigurationBuilder userPassword(String userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        public EmailConfigurationBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public EmailConfigurationBuilder emailAuthenticationMethod(EmailAuthenticationMethod emailAuthenticationMethod) {
            this.emailAuthenticationMethod = emailAuthenticationMethod;
            return this;
        }

        public EmailConfigurationBuilder oauth2Connection(OAuth2Connection oauth2Connection) {
            this.oauth2Connection = oauth2Connection;
            return this;
        }

        public EmailConfigurationBuilder bufferedSender(Boolean bufferedSender) {
            this.bufferedSender = bufferedSender;
            return this;
        }

        public EmailConfigurationBuilder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public EmailConfigurationBuilder period(Integer period) {
            this.period = period;
            return this;
        }

        public EmailConfigurationBuilder tryAfter(Integer tryAfter) {
            this.tryAfter = tryAfter;
            return this;
        }

        public EmailConfiguration build() {
            return new EmailConfiguration(this.id, this.name, this.email, this.defaultConfiguration, this.mailServer, this.smtpMailServer, this.smtpPortNumber, this.sourceAddress, this.timeout, this.mailUser, this.useSSL, this.useStartTLS, this.smtpUser, this.userPassword, this.debug, this.emailAuthenticationMethod, this.oauth2Connection, this.bufferedSender, this.maxAttempts, this.period, this.tryAfter);
        }

        public String toString() {
            return "EmailConfiguration.EmailConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", email=" + this.email + ", defaultConfiguration=" + this.defaultConfiguration + ", mailServer=" + this.mailServer + ", smtpMailServer=" + this.smtpMailServer + ", smtpPortNumber=" + this.smtpPortNumber + ", sourceAddress=" + this.sourceAddress + ", timeout=" + this.timeout + ", mailUser=" + this.mailUser + ", useSSL=" + this.useSSL + ", useStartTLS=" + this.useStartTLS + ", smtpUser=" + this.smtpUser + ", userPassword=" + this.userPassword + ", debug=" + this.debug + ", emailAuthenticationMethod=" + (Object)((Object)this.emailAuthenticationMethod) + ", oauth2Connection=" + this.oauth2Connection + ", bufferedSender=" + this.bufferedSender + ", maxAttempts=" + this.maxAttempts + ", period=" + this.period + ", tryAfter=" + this.tryAfter + ")";
        }
    }
}

