/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;

public class BooleanType
extends JsonTypeBase<Boolean> {
    private static final Boolean defaultValue = false;
    public static final BooleanType INSTANCE = new BooleanType();

    private BooleanType() {
        super(Boolean.class, defaultValue);
        this.converter(String.class, new TypeBase.Convert<String, Boolean>(){

            @Override
            public String fromBase(Boolean value) {
                return value.toString();
            }

            @Override
            public Boolean toBase(String value) {
                return BooleanType.this.convert(value);
            }
        });
    }

    @Override
    public String name() {
        return "boolean";
    }

    @Override
    public String translationKey() {
        return "Logiczny";
    }

    @Override
    protected JsonNode serializeNonNullValue(Boolean value) {
        return BooleanNode.valueOf((boolean)value);
    }

    @Override
    protected Boolean deserializeNonEmptyNode(JsonNode json) {
        return json.asBoolean();
    }

    @Override
    public Boolean convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }
}

