/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.exception.IllegalExpirationTypeException;
import com.suncode.pwfl.translation.configElements.DocumentClassTranslation;
import com.suncode.pwfl.web.ui.DivanteColor;
import com.suncode.pwfl.web.ui.DivanteIcon;
import java.beans.ConstructorProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="pm_docclasses")
@SequenceGenerator(name="pm_docclasses_id_seq", sequenceName="pm_docclasses_id_seq")
public class DocumentClass {
    public static String DEFAULT_LOGICAL_CONNECTION = "AND";
    public static final String JOIN_DEVICE = "directory.device";
    public static final String JOIN_DIRECTORY = "directory";
    public static final String JOIN_INDEXES = "indexes";
    public static final String JOIN_ACTIONS = "actions";
    public static final String JOIN_FILES = "files";
    public static final String JOIN_TRANSLATIONS = "translations";
    public static final String NAME_COLUMN_NAME = "docclassname";
    public static final String DESC_COLUMN_NAME = "docclassdescription";
    @Id
    @Column(name="id")
    @Access(value=AccessType.PROPERTY)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_docclasses_id_seq")
    @NonNull
    private Long id;
    @Column(name="docclassname", unique=true)
    private String name;
    @Column(name="docclassdescription")
    private String description;
    @Column(name="maxfilesize")
    private Long maxFileSize;
    @Column(name="docclassexpiretiondate")
    private String expiration;
    @Column(name="docclassexpiretiontype")
    private String expirationType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassdirectoryid", nullable=false)
    private Directory directory;
    @Column(name="docclassencoding")
    private boolean encoding;
    @Column(name="docclasscompressing")
    private boolean compressing;
    @Column(name="docclassftsserverid")
    private Long ftsServerId;
    private String cipherAlgorithm;
    private Long keyLength;
    @Column(name="docclassorderid")
    private Long orderId;
    @Column(name="docclassindexpath")
    private String indexPath;
    @Column(name="docclassindex")
    private boolean indexing;
    @Column(name="logicalconn")
    private String logicalConnection = DEFAULT_LOGICAL_CONNECTION;
    @Column(name="docclassiconname", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DivanteIcon iconName = DivanteIcon.FOLDER;
    @Column(name="docclassiconcolor", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DivanteColor iconColor = DivanteColor.BLUE;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    private Set<WfFile> files;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    private Set<DocumentClassAction> actions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    private Set<DocumentClassIndex> indexes;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    private Set<LinkConnection> linkConnections;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="translatedEntity", cascade={CascadeType.REMOVE})
    private List<DocumentClassTranslation> translations;

    public String getIconName() {
        return this.iconName.getCode();
    }

    public void setIconName(String iconName) {
        this.iconName = DivanteIcon.fromCode(iconName);
    }

    public String getIconColor() {
        return this.iconColor.getCode();
    }

    public void setIconColor(String iconColor) {
        this.iconColor = DivanteColor.fromCode(iconColor);
    }

    public Set<DocumentClassAction> getActions() {
        if (this.actions == null) {
            return new HashSet<DocumentClassAction>();
        }
        return this.actions;
    }

    public Set<DocumentClassIndex> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new HashSet<DocumentClassIndex>();
        }
        return this.indexes;
    }

    public void addIndex(DocumentClassIndex index) {
        this.getIndexes().add(index);
    }

    public void addAction(DocumentClassAction action) {
        this.getActions().add(action);
    }

    @Transient
    public Date getExpirationDate() throws ParseException, IllegalExpirationTypeException {
        if (this.expirationType == null || StringUtils.isBlank((String)this.expiration)) {
            return null;
        }
        if (this.expirationType.equals("endDay")) {
            return new SimpleDateFormat("y-M-d").parse(this.expiration);
        }
        if (this.expirationType.equals("period") || this.expirationType.equals("dayCnt")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, Integer.valueOf(this.expiration));
            return calendar.getTime();
        }
        return null;
    }

    public static DocumentClassBuilder builder() {
        return new DocumentClassBuilder();
    }

    @NonNull
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getExpirationType() {
        return this.expirationType;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public boolean isEncoding() {
        return this.encoding;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public Long getFtsServerId() {
        return this.ftsServerId;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public Long getKeyLength() {
        return this.keyLength;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public boolean isIndexing() {
        return this.indexing;
    }

    public String getLogicalConnection() {
        return this.logicalConnection;
    }

    public Set<WfFile> getFiles() {
        return this.files;
    }

    public Set<LinkConnection> getLinkConnections() {
        return this.linkConnections;
    }

    public List<DocumentClassTranslation> getTranslations() {
        return this.translations;
    }

    public void setId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public void setExpirationType(String expirationType) {
        this.expirationType = expirationType;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public void setFtsServerId(Long ftsServerId) {
        this.ftsServerId = ftsServerId;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setKeyLength(Long keyLength) {
        this.keyLength = keyLength;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public void setIndexing(boolean indexing) {
        this.indexing = indexing;
    }

    public void setLogicalConnection(String logicalConnection) {
        this.logicalConnection = logicalConnection;
    }

    public void setFiles(Set<WfFile> files) {
        this.files = files;
    }

    public void setActions(Set<DocumentClassAction> actions) {
        this.actions = actions;
    }

    public void setIndexes(Set<DocumentClassIndex> indexes) {
        this.indexes = indexes;
    }

    public void setLinkConnections(Set<LinkConnection> linkConnections) {
        this.linkConnections = linkConnections;
    }

    public void setTranslations(List<DocumentClassTranslation> translations) {
        this.translations = translations;
    }

    public DocumentClass() {
    }

    @ConstructorProperties(value={"id", "name", "description", "maxFileSize", "expiration", "expirationType", "directory", "encoding", "compressing", "ftsServerId", "cipherAlgorithm", "keyLength", "orderId", "indexPath", "indexing", "logicalConnection", "iconName", "iconColor", "files", "actions", "indexes", "linkConnections", "translations"})
    public DocumentClass(@NonNull Long id, String name, String description, Long maxFileSize, String expiration, String expirationType, Directory directory, boolean encoding, boolean compressing, Long ftsServerId, String cipherAlgorithm, Long keyLength, Long orderId, String indexPath, boolean indexing, String logicalConnection, DivanteIcon iconName, DivanteColor iconColor, Set<WfFile> files, Set<DocumentClassAction> actions, Set<DocumentClassIndex> indexes, Set<LinkConnection> linkConnections, List<DocumentClassTranslation> translations) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.maxFileSize = maxFileSize;
        this.expiration = expiration;
        this.expirationType = expirationType;
        this.directory = directory;
        this.encoding = encoding;
        this.compressing = compressing;
        this.ftsServerId = ftsServerId;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.orderId = orderId;
        this.indexPath = indexPath;
        this.indexing = indexing;
        this.logicalConnection = logicalConnection;
        this.iconName = iconName;
        this.iconColor = iconColor;
        this.files = files;
        this.actions = actions;
        this.indexes = indexes;
        this.linkConnections = linkConnections;
        this.translations = translations;
    }

    @ConstructorProperties(value={"id"})
    public DocumentClass(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    public static class DocumentClassBuilder {
        private Long id;
        private String name;
        private String description;
        private Long maxFileSize;
        private String expiration;
        private String expirationType;
        private Directory directory;
        private boolean encoding;
        private boolean compressing;
        private Long ftsServerId;
        private String cipherAlgorithm;
        private Long keyLength;
        private Long orderId;
        private String indexPath;
        private boolean indexing;
        private String logicalConnection;
        private DivanteIcon iconName;
        private DivanteColor iconColor;
        private Set<WfFile> files;
        private Set<DocumentClassAction> actions;
        private Set<DocumentClassIndex> indexes;
        private Set<LinkConnection> linkConnections;
        private List<DocumentClassTranslation> translations;

        DocumentClassBuilder() {
        }

        public DocumentClassBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DocumentClassBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DocumentClassBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentClassBuilder maxFileSize(Long maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public DocumentClassBuilder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public DocumentClassBuilder expirationType(String expirationType) {
            this.expirationType = expirationType;
            return this;
        }

        public DocumentClassBuilder directory(Directory directory) {
            this.directory = directory;
            return this;
        }

        public DocumentClassBuilder encoding(boolean encoding) {
            this.encoding = encoding;
            return this;
        }

        public DocumentClassBuilder compressing(boolean compressing) {
            this.compressing = compressing;
            return this;
        }

        public DocumentClassBuilder ftsServerId(Long ftsServerId) {
            this.ftsServerId = ftsServerId;
            return this;
        }

        public DocumentClassBuilder cipherAlgorithm(String cipherAlgorithm) {
            this.cipherAlgorithm = cipherAlgorithm;
            return this;
        }

        public DocumentClassBuilder keyLength(Long keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        public DocumentClassBuilder orderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public DocumentClassBuilder indexPath(String indexPath) {
            this.indexPath = indexPath;
            return this;
        }

        public DocumentClassBuilder indexing(boolean indexing) {
            this.indexing = indexing;
            return this;
        }

        public DocumentClassBuilder logicalConnection(String logicalConnection) {
            this.logicalConnection = logicalConnection;
            return this;
        }

        public DocumentClassBuilder iconName(DivanteIcon iconName) {
            this.iconName = iconName;
            return this;
        }

        public DocumentClassBuilder iconColor(DivanteColor iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public DocumentClassBuilder files(Set<WfFile> files) {
            this.files = files;
            return this;
        }

        public DocumentClassBuilder actions(Set<DocumentClassAction> actions) {
            this.actions = actions;
            return this;
        }

        public DocumentClassBuilder indexes(Set<DocumentClassIndex> indexes) {
            this.indexes = indexes;
            return this;
        }

        public DocumentClassBuilder linkConnections(Set<LinkConnection> linkConnections) {
            this.linkConnections = linkConnections;
            return this;
        }

        public DocumentClassBuilder translations(List<DocumentClassTranslation> translations) {
            this.translations = translations;
            return this;
        }

        public DocumentClass build() {
            return new DocumentClass(this.id, this.name, this.description, this.maxFileSize, this.expiration, this.expirationType, this.directory, this.encoding, this.compressing, this.ftsServerId, this.cipherAlgorithm, this.keyLength, this.orderId, this.indexPath, this.indexing, this.logicalConnection, this.iconName, this.iconColor, this.files, this.actions, this.indexes, this.linkConnections, this.translations);
        }

        public String toString() {
            return "DocumentClass.DocumentClassBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", maxFileSize=" + this.maxFileSize + ", expiration=" + this.expiration + ", expirationType=" + this.expirationType + ", directory=" + this.directory + ", encoding=" + this.encoding + ", compressing=" + this.compressing + ", ftsServerId=" + this.ftsServerId + ", cipherAlgorithm=" + this.cipherAlgorithm + ", keyLength=" + this.keyLength + ", orderId=" + this.orderId + ", indexPath=" + this.indexPath + ", indexing=" + this.indexing + ", logicalConnection=" + this.logicalConnection + ", iconName=" + this.iconName + ", iconColor=" + (Object)((Object)this.iconColor) + ", files=" + this.files + ", actions=" + this.actions + ", indexes=" + this.indexes + ", linkConnections=" + this.linkConnections + ", translations=" + this.translations + ")";
        }
    }
}

