/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.scheduledtask;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinition;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskFindResultDto;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.InvocableComponent;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScheduledTask
extends InvocableComponent {
    public static final String EXECUTE_SCHEDULED_TASK_METHOD_NAME = "execute";
    private boolean cancelable;

    public ScheduledTask(ScheduledTaskDefinition definition, Method method, Object instance) {
        super(definition, method, instance);
        this.cancelable = definition.isCancelable();
    }

    @Override
    protected Object invokeWithResult(Parameters parameters, Object ... instances) {
        return super.invokeWithResult(parameters, instances);
    }

    @Override
    public void invoke(Parameters parameters, ActivityContextMap activityContextMap, ContextVariables contextVariables) {
        super.invoke(parameters, new Object[0]);
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public ScheduledTaskFindResultDto info() {
        ScheduledTaskFindResultDto taskDto = new ScheduledTaskFindResultDto();
        taskDto.setName(EXECUTE_SCHEDULED_TASK_METHOD_NAME);
        taskDto.setClassName(this.getDeclaringClass().getName());
        taskDto.setReturns(this.getInvocableMethod().getMethod().getReturnType().getSimpleName());
        taskDto.setAnnotationName(this.notNull(this.getName()));
        taskDto.setAnnotationDesc(this.notNull(this.getDescription()));
        taskDto.setCategory(this.notNull(this.getCategoriesAsString()));
        taskDto.setCancelable(this.isCancelable());
        taskDto.setIsComponent(true);
        taskDto.setComponentTaskId(this.getId());
        taskDto.setDeprecated(this.isDeprecated());
        List<ParameterDefinition<?>> parameters = this.getParameters();
        if (!parameters.isEmpty()) {
            LinkedList<ScheduledTaskFindResultDto.Parameter> paramsDtoList = new LinkedList<ScheduledTaskFindResultDto.Parameter>();
            for (int i = 0; i < parameters.size(); ++i) {
                ParameterDefinition<?> param = parameters.get(i);
                ScheduledTaskFindResultDto.Parameter paramDto = new ScheduledTaskFindResultDto.Parameter();
                paramDto.setPosition(i);
                paramDto.setType(param.getType().javaType().getName());
                paramDto.setAnnotationName(this.notNull(param.getName()));
                paramDto.setAnnotationDesc(this.notNull(param.getDescription()));
                paramDto.setFieldType(param.getType().toString());
                paramDto.setComponentParameterId(param.getId());
                paramDto.setIsOptional(param.isOptional());
                paramDto.setDefaultValue(param.getDefaultValue());
                paramsDtoList.add(paramDto);
            }
            taskDto.setParameters(paramsDtoList);
        }
        return taskDto;
    }

    private String notNull(String value) {
        return value == null ? "" : value;
    }

    private String getCategoriesAsString() {
        return StringUtils.join(this.getCategories(), (String)", ");
    }
}

