/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.translation.configElements.LinkTranslation;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_links")
@SequenceGenerator(name="pm_links_id_seq", sequenceName="pm_links_id_seq")
public class Link {
    public static final String JOIN_CONNECTIONS = "connections";
    public static final String JOIN_CONNECTION_DOCUMENT_CLASS = "connections.documentClass";
    public static final String JOIN_CONNECTION_LINK_INDEX = "connections.linkIndex";
    public static final String JOIN_CONNECTION_DOCUMENT_CLASS_INDEX = "connections.documentClassIndex";
    public static final String NAME_COLUMN_NAME = "linkname";
    public static final String DESC_COLUMN_NAME = "linkdescription";
    public static final String JOIN_TRANSLATIONS = "translations";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_links_id_seq")
    private Long id;
    @Column(name="linkname")
    private String name;
    @Column(name="linkdescription")
    private String description;
    @OneToMany(mappedBy="link", cascade={CascadeType.ALL})
    private Set<LinkConnection> connections;
    @OneToMany(mappedBy="link", cascade={CascadeType.ALL})
    private Set<LinkIndex> indexes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="translatedEntity", cascade={CascadeType.REMOVE})
    private List<LinkTranslation> translations;

    public static LinkBuilder builder() {
        return new LinkBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<LinkConnection> getConnections() {
        return this.connections;
    }

    public Set<LinkIndex> getIndexes() {
        return this.indexes;
    }

    public List<LinkTranslation> getTranslations() {
        return this.translations;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setConnections(Set<LinkConnection> connections) {
        this.connections = connections;
    }

    public void setIndexes(Set<LinkIndex> indexes) {
        this.indexes = indexes;
    }

    public void setTranslations(List<LinkTranslation> translations) {
        this.translations = translations;
    }

    public Link() {
    }

    @ConstructorProperties(value={"id", "name", "description", "connections", "indexes", "translations"})
    public Link(Long id, String name, String description, Set<LinkConnection> connections, Set<LinkIndex> indexes, List<LinkTranslation> translations) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.connections = connections;
        this.indexes = indexes;
        this.translations = translations;
    }

    public static class LinkBuilder {
        private Long id;
        private String name;
        private String description;
        private Set<LinkConnection> connections;
        private Set<LinkIndex> indexes;
        private List<LinkTranslation> translations;

        LinkBuilder() {
        }

        public LinkBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LinkBuilder description(String description) {
            this.description = description;
            return this;
        }

        public LinkBuilder connections(Set<LinkConnection> connections) {
            this.connections = connections;
            return this;
        }

        public LinkBuilder indexes(Set<LinkIndex> indexes) {
            this.indexes = indexes;
            return this;
        }

        public LinkBuilder translations(List<LinkTranslation> translations) {
            this.translations = translations;
            return this;
        }

        public Link build() {
            return new Link(this.id, this.name, this.description, this.connections, this.indexes, this.translations);
        }

        public String toString() {
            return "Link.LinkBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", connections=" + this.connections + ", indexes=" + this.indexes + ", translations=" + this.translations + ")";
        }
    }
}

