/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum IndexType {
    STRING("string", "Tekstowy"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    LONG("integer", "Calkowity"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Long.valueOf(value);
        }
    }
    ,
    LIST("list", "Lista_wartosci"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    DATE("date", "Data"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return new LocalDate((Object)value);
        }
    }
    ,
    DATETIME("dateTime", "Data_i_czas"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            try {
                return LocalDateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                return value;
            }
        }
    }
    ,
    DOUBLE("float", "Zmiennoprzecinkowy"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Double.valueOf(value);
        }
    }
    ,
    BOOLEAN("boolean", "Logiczny"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Boolean.valueOf(value);
        }
    };

    private String value;
    private String translationKey;

    private IndexType(String value, String translationKey) {
        this.value = value;
        this.translationKey = translationKey;
    }

    public String toString() {
        return this.value;
    }

    public static IndexType getType(String name) {
        for (IndexType indexType : IndexType.values()) {
            if (!indexType.value.equals(name)) continue;
            return indexType;
        }
        throw new RuntimeException("No such type value: " + name);
    }

    public abstract Object parse(String var1);

    public String getTranslationKey() {
        return this.translationKey;
    }
}

