/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.support.CustomService;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityAssignment;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.ActivityStateEntity;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessEntity;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

public class ActivityEntity
implements Activity {
    private String activityId;
    private String activityDefinitionId;
    private String rawName;
    private String translatedName;
    private String rawDescription;
    private String translatedDescription;
    private Long objectId;
    private ActivityStateEntity activityState;
    private ActivityState state;
    private Set<ActivityAssignment> assignments;
    private ProcessEntity process;
    private ProcessDefinition processDefinition;
    private Set<ActivityDocument> documents;
    private Long lAcceptedTime;
    private Long lActivatedTime;
    private Long lLastStateTime;
    private Long lLimitTime;
    private Date startedTime;
    private Date createdTime;
    private Date lastStateTime;
    private String resourceId;
    private Long objectVersion;
    private String processId;

    public void setStartedTime(Date startedTime) {
        this.startedTime = startedTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public void setLastStateTime(Date lastStateTime) {
        this.lastStateTime = lastStateTime;
    }

    @Override
    public ProcessEntity getProcess() {
        return this.process;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ActivityStateEntity getActivityState() {
        return this.activityState;
    }

    public void setActivityState(ActivityStateEntity activityState) {
        this.activityState = activityState;
        if (activityState != null) {
            this.state = ActivityState.getState(activityState.getName());
        }
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getName() {
        if (this.translatedName == null) {
            this.translatedName = this.translateName();
        }
        return this.translatedName;
    }

    private String translateName() {
        this.initializeProcessDefinition();
        return PackageTranslationHelper.getActivityName((String)this.processDefinition.getPackageId(), (String)this.processDefinition.getProcessDefinitionId(), (String)this.activityDefinitionId);
    }

    private void initializeProcessDefinition() {
        if (this.processDefinition == null) {
            if (this.process != null && Hibernate.isInitialized((Object)this.process)) {
                this.processDefinition = this.process.getProcessDefinition();
            }
            if (this.processDefinition == null || !Hibernate.isInitialized((Object)this.processDefinition)) {
                this.processDefinition = ServiceFactory.getProcessService().getProcess(this.processId, "processDefinition").getProcessDefinition();
            }
        }
    }

    public void setName(String name) {
        this.rawName = name;
    }

    private String getRawName() {
        return this.rawName;
    }

    private void setRawName(String rawName) {
        this.rawName = rawName;
    }

    @Override
    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public void setProcess(ProcessEntity process) {
        this.process = process;
    }

    @Override
    public String getDescription() {
        if (this.translatedDescription == null) {
            this.translatedDescription = this.translateDescription();
        }
        return this.translatedDescription;
    }

    private String translateDescription() {
        this.initializeProcessDefinition();
        return PackageTranslationHelper.getActivityDescription((String)this.processDefinition.getPackageId(), (String)this.processDefinition.getProcessDefinitionId(), (String)this.activityDefinitionId);
    }

    public void setDescription(String description) {
        this.rawDescription = description;
    }

    private String getRawDescription() {
        return this.rawDescription;
    }

    private void setRawDescription(String rawDescription) {
        this.rawDescription = rawDescription;
    }

    @Override
    public String getActivityDefinitionId() {
        return this.activityDefinitionId;
    }

    public void setActivityDefinitionId(String activityDefinitionId) {
        this.activityDefinitionId = activityDefinitionId;
    }

    private Long getlAcceptedTime() {
        return this.lAcceptedTime;
    }

    private void setlAcceptedTime(Long lAcceptedTime) {
        this.lAcceptedTime = lAcceptedTime;
        this.startedTime = new Date(lAcceptedTime);
    }

    private Long getlActivatedTime() {
        return this.lActivatedTime;
    }

    private void setlActivatedTime(Long lActivatedTime) {
        this.lActivatedTime = lActivatedTime;
        this.createdTime = new Date(lActivatedTime);
    }

    private Long getlLastStateTime() {
        return this.lLastStateTime;
    }

    private void setlLastStateTime(Long lLastStateTime) {
        this.lLastStateTime = lLastStateTime;
        this.lastStateTime = new Date(lLastStateTime);
    }

    private Long getlLimitTime() {
        return this.lLimitTime;
    }

    private void setlLimitTime(Long lLimitTime) {
        this.lLimitTime = lLimitTime;
    }

    @Override
    public Date getStartedTime() {
        return this.startedTime;
    }

    @Override
    public Date getActivatedTime() {
        if (Objects.isNull(this.lActivatedTime)) {
            return null;
        }
        return new Date(this.lActivatedTime);
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getLastStateTime() {
        return this.lastStateTime;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Set<ActivityAssignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(Set<ActivityAssignment> assignments) {
        this.assignments = assignments;
    }

    public Set<ActivityDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Set<ActivityDocument> documents) {
        this.documents = documents;
    }

    @Override
    public boolean isOpen() {
        return ActivityState.isOpen(this.getState());
    }

    @Override
    public ActivityState getState() {
        return this.state;
    }

    public void setState(ActivityState state) {
        this.state = state;
        CustomService<ActivityStateEntity, Long> cs = ServiceFactory.getCustomService(ActivityStateEntity.class, Long.class);
        this.activityState = cs.getByField("name", ActivityState.getSharkState(state), new String[0]);
    }

    @Override
    public Long getObjectVersion() {
        return this.objectVersion;
    }

    public void setObjectVersion(Long objectVersion) {
        this.objectVersion = objectVersion;
    }
}

