/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive.dto;

import com.suncode.pwfl.archive.LinkIndex;
import java.beans.ConstructorProperties;

public class LinkIndexDto {
    private Long id;
    private Long linkId;
    private String indexName;
    private String indexDescription;
    private String indexType;
    private String indexValues;
    private Long indexOrder;

    public String[] getValues() {
        String[] values = this.indexValues.split("\n");
        if (values != null && values.length <= 1) {
            values = this.indexValues.split(",");
        }
        return values;
    }

    public static LinkIndexDto from(LinkIndex linkIndex) {
        return LinkIndexDto.builder().id(linkIndex.getId()).linkId(linkIndex.getLink().getId()).indexName(linkIndex.getName()).indexDescription(linkIndex.getDescription()).indexType(linkIndex.getType()).indexValues(linkIndex.getValues()).indexOrder(linkIndex.getOrder()).build();
    }

    public static LinkIndexDtoBuilder builder() {
        return new LinkIndexDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getLinkId() {
        return this.linkId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexDescription() {
        return this.indexDescription;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getIndexValues() {
        return this.indexValues;
    }

    public Long getIndexOrder() {
        return this.indexOrder;
    }

    public LinkIndexDto() {
    }

    @ConstructorProperties(value={"id", "linkId", "indexName", "indexDescription", "indexType", "indexValues", "indexOrder"})
    public LinkIndexDto(Long id, Long linkId, String indexName, String indexDescription, String indexType, String indexValues, Long indexOrder) {
        this.id = id;
        this.linkId = linkId;
        this.indexName = indexName;
        this.indexDescription = indexDescription;
        this.indexType = indexType;
        this.indexValues = indexValues;
        this.indexOrder = indexOrder;
    }

    public static class LinkIndexDtoBuilder {
        private Long id;
        private Long linkId;
        private String indexName;
        private String indexDescription;
        private String indexType;
        private String indexValues;
        private Long indexOrder;

        LinkIndexDtoBuilder() {
        }

        public LinkIndexDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkIndexDtoBuilder linkId(Long linkId) {
            this.linkId = linkId;
            return this;
        }

        public LinkIndexDtoBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public LinkIndexDtoBuilder indexDescription(String indexDescription) {
            this.indexDescription = indexDescription;
            return this;
        }

        public LinkIndexDtoBuilder indexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        public LinkIndexDtoBuilder indexValues(String indexValues) {
            this.indexValues = indexValues;
            return this;
        }

        public LinkIndexDtoBuilder indexOrder(Long indexOrder) {
            this.indexOrder = indexOrder;
            return this;
        }

        public LinkIndexDto build() {
            return new LinkIndexDto(this.id, this.linkId, this.indexName, this.indexDescription, this.indexType, this.indexValues, this.indexOrder);
        }

        public String toString() {
            return "LinkIndexDto.LinkIndexDtoBuilder(id=" + this.id + ", linkId=" + this.linkId + ", indexName=" + this.indexName + ", indexDescription=" + this.indexDescription + ", indexType=" + this.indexType + ", indexValues=" + this.indexValues + ", indexOrder=" + this.indexOrder + ")";
        }
    }
}

