/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process;

import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.process.IndexInfo;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessState;
import com.suncode.pwfl.workflow.process.ProcessStateEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Transient;
import org.hibernate.Hibernate;

public class ProcessEntity
implements Process {
    public static final String JOIN_ACTIVITIES = "activities";
    public static final String JOIN_PROCESS_DEFINITION = "processDefinition";
    private String processId;
    private String translatedName;
    private String rawName;
    private boolean indexLoaded;
    private Long objectId;
    private Long objectVersion;
    private String translatedDescription;
    private String rawDescription;
    private Long rawCreated;
    private Long rawStarted;
    private Long rawLastStateTime;
    private Long rawLimitTime;
    private ProcessStateEntity processState;
    private ProcessState state;
    private ProcessDefinition processDefinition;
    private Set<ActivityEntity> activities;
    private List<IndexInfo> indexes = new ArrayList<IndexInfo>();

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Override
    @Transient
    public String getName() {
        if (this.translatedName == null) {
            this.translatedName = this.translateName(this.getRawName());
        }
        return this.translatedName;
    }

    private String translateName(String name) {
        this.initializeProcessDefinition();
        return PackageTranslationHelper.getProcessName((String)this.processDefinition.getPackageId(), (String)this.processDefinition.getProcessDefinitionId(), (String)name);
    }

    private void initializeProcessDefinition() {
        if (this.processDefinition == null || !Hibernate.isInitialized((Object)this.processDefinition)) {
            this.processDefinition = ServiceFactory.getProcessService().getProcess(this.processId, JOIN_PROCESS_DEFINITION).getProcessDefinition();
        }
    }

    @Override
    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    @Override
    public String getDescription() {
        if (this.translatedDescription == null) {
            this.translatedDescription = this.translateDescription();
        }
        return this.translatedDescription;
    }

    public void setDescription(String description) {
        this.rawDescription = description;
    }

    private String translateDescription() {
        this.initializeProcessDefinition();
        return PackageTranslationHelper.getProcessDescription((String)this.processDefinition.getPackageId(), (String)this.processDefinition.getProcessDefinitionId());
    }

    private String getRawDescription() {
        return this.rawDescription;
    }

    private void setRawDescription(String description) {
        this.rawDescription = description;
    }

    private Long getRawCreated() {
        return this.rawCreated;
    }

    private void setRawCreated(Long created) {
        this.rawCreated = created;
    }

    private Long getRawStarted() {
        return this.rawStarted;
    }

    private void setRawStarted(Long started) {
        this.rawStarted = started;
    }

    private Long getRawLastStateTime() {
        return this.rawLastStateTime;
    }

    private void setRawLastStateTime(Long lastStateTime) {
        this.rawLastStateTime = lastStateTime;
    }

    @Override
    public Date getCreatedTime() {
        return new Date(this.rawCreated);
    }

    public void setCreatedTime(Date created) {
        this.rawCreated = created.getTime();
    }

    @Override
    public Date getStartedTime() {
        return new Date(this.rawStarted);
    }

    public void setStartedTime(Date started) {
        this.rawStarted = started.getTime();
    }

    @Override
    public Date getLastStateTime() {
        return new Date(this.rawLastStateTime);
    }

    public void setLastStateTime(Date lastStateTime) {
        this.rawLastStateTime = lastStateTime.getTime();
    }

    @Override
    public Date getLimitTime() {
        return new Date(this.rawLimitTime);
    }

    public ProcessStateEntity getProcessState() {
        return this.processState;
    }

    public void setProcessState(ProcessStateEntity processState) {
        this.processState = processState;
        if (processState != null) {
            this.state = ProcessState.getState(processState.getName());
        }
    }

    @Override
    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public Set<ActivityEntity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<ActivityEntity> activities) {
        this.activities = activities;
    }

    public ProcessEntity(String processId) {
        this.processId = processId;
    }

    public ProcessEntity() {
    }

    @Transient
    public List<IndexInfo> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexInfo> indexes) {
        this.indexes = indexes;
    }

    public void addIndex(IndexInfo indexInfo) {
        this.indexes.add(indexInfo);
    }

    @Override
    public IndexInfo getIndex(String id) {
        this.checkIndexLoaded();
        for (IndexInfo ii : this.indexes) {
            if (!ii.getId().equals(id)) continue;
            return ii;
        }
        return null;
    }

    @Override
    public Object getIndexValue(String id) {
        this.checkIndexLoaded();
        IndexInfo ii = this.getIndex(id);
        if (ii == null) {
            throw new NullPointerException("Nie znaleziono indeksu o id: " + id);
        }
        return ii.getValue();
    }

    private void checkIndexLoaded() {
        if (!this.indexLoaded) {
            throw new IllegalStateException("Indeksy dla procesu: " + this.processId + " nie s\u0105 za\u0142adowane");
        }
    }

    @Override
    public String getRawName() {
        return this.rawName;
    }

    public void setRawName(String rawName) {
        this.rawName = rawName;
    }

    @Override
    @Transient
    public boolean isIndexLoaded() {
        return this.indexLoaded;
    }

    public void setIndexLoaded(boolean indexLoaded) {
        this.indexLoaded = indexLoaded;
    }

    @Override
    public Long getObjectVersion() {
        return this.objectVersion;
    }

    public void setObjectVersion(Long objectVersion) {
        this.objectVersion = objectVersion;
    }

    public Long getRawLimitTime() {
        return this.rawLimitTime;
    }

    public void setRawLimitTime(Long rawLimitTime) {
        this.rawLimitTime = rawLimitTime;
    }
}

