/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum DivanteColor {
    ORANGE("orange"),
    ORANGE_PALE("orange-pale"),
    BLUE("blue"),
    BLUE_ACTIVE("blue-active"),
    GRAY_PALE("gray-pale"),
    WHITE("white"),
    RED("red"),
    GREEN("green"),
    BLUE_PALE("blue-pale"),
    TABLE_BLACK("table-black"),
    TABLE_BLACK_ACTIVE("table-black-active"),
    TABLE_GRAY("table-gray"),
    DARK_BLUE("dark-blue"),
    GRAY("gray"),
    ICON_GRAY("icon-gray"),
    TABLE_TEXT_GRAY("table-text-gray");

    private String code;

    private DivanteColor(String code) {
        this.code = code;
    }

    public static DivanteColor fromString(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        return DivanteColor.valueOf(text.trim().toUpperCase());
    }

    public static DivanteColor fromCode(String code) {
        return Stream.of(DivanteColor.values()).filter(icon -> icon.code.equals(code)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public String getCode() {
        return this.code;
    }
}

