/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process;

import com.suncode.pwfl.util.exception.ServiceException;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;

@Entity
@Table(name="pm_activitycomments")
@SequenceGenerator(name="pm_activitycommnets_id_seq", sequenceName="pm_activitycomments_id_seq")
public class Comment {
    private Long id;
    private String processId;
    private String activityId;
    private String userId;
    private String comment;
    private Long timestamp;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_activitycommnets_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public Date getCommentDate() {
        if (this.timestamp != null) {
            return new Date(this.timestamp);
        }
        return null;
    }

    @Transient
    public String getUserFullName() {
        try {
            return Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(this.userId);
        }
        catch (BaseException e) {
            throw new ServiceException(e);
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Column(name="activity_comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

