/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.exception;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.xpdl.util.ValidationErrorLevel;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class XpdlPackageValidationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String NEW_LINE = "<br>";
    private String errorLevel = ValidationErrorLevel.GLOBAL.getName();
    private String messageBundleKey = "";
    private String processDefId = "";
    private String roleId = "";
    private String variableId = "";
    private String activityDefId = "";
    private String transitionId = "";
    private String applicationName = "";

    public XpdlPackageValidationException(String msg) {
        super(msg);
    }

    public String getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(ValidationErrorLevel validationErrorLevel) {
        if (validationErrorLevel != null) {
            this.errorLevel = validationErrorLevel.getName();
        }
    }

    public String getMessageBundleKey() {
        return this.messageBundleKey;
    }

    public void setMessageBundleKey(String messageBundleKey) {
        this.messageBundleKey = messageBundleKey;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getTranslatedMessage(Locale locale) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getTranslatedMessageMainPart(locale));
        msg.append(this.getTranslatedMessagePostfix(locale));
        return msg.toString();
    }

    private String getTranslatedMessageMainPart(Locale locale) {
        String msg = StringUtils.defaultString((String)this.messageBundleKey);
        return MessageHelper.getOptionalMessage((String)msg, (Locale)locale, (Object[])new Object[0]);
    }

    private String getTranslatedMessagePostfix(Locale locale) {
        switch (ValidationErrorLevel.getByName(this.errorLevel)) {
            case PROCESS: {
                return this.getTranslatedMessagePostfixForProcessError(locale);
            }
            case VARIABLE: {
                return this.getTranslatedMessagePostfixForVariableError(locale);
            }
            case GLOBAL_ROLE: 
            case ROLE: {
                return this.getTranslatedMessagePostfixForRoleError(locale);
            }
            case ACTIVITY: {
                return this.getTranslatedMessagePostfixForActivityError(locale);
            }
            case ACTIVITY_APPLICATION: 
            case ACTIVITY_APPLICATION_PARAM: {
                return this.getTranslatedMessagePostfixForApplicationError(locale);
            }
            case TRANSITION: {
                return this.getTranslatedMessagePostfixForTransitionError(locale);
            }
        }
        return "";
    }

    private String getTranslatedMessagePostfixForProcessError(Locale locale) {
        return this.getTranslatedMessagePostfixForError("xpdl.validation.process", this.processDefId, locale);
    }

    private String getTranslatedMessagePostfixForVariableError(Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(this.getTranslatedMessagePostfixForProcessError(locale));
        postfix.append(this.getTranslatedMessagePostfixForError("xpdl.validation.process_variable", this.variableId, locale));
        return postfix.toString();
    }

    private String getTranslatedMessagePostfixForRoleError(Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(this.getTranslatedMessagePostfixForProcessError(locale));
        postfix.append(this.getTranslatedMessagePostfixForError("xpdl.validation.role", this.roleId, locale));
        return postfix.toString();
    }

    private String getTranslatedMessagePostfixForActivityError(Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(this.getTranslatedMessagePostfixForProcessError(locale));
        postfix.append(this.getTranslatedMessagePostfixForError("xpdl.validation.activity", this.activityDefId, locale));
        return postfix.toString();
    }

    private String getTranslatedMessagePostfixForApplicationError(Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(this.getTranslatedMessagePostfixForProcessError(locale));
        postfix.append(this.getTranslatedMessagePostfixForActivityError(locale));
        postfix.append(this.getTranslatedMessagePostfixForError("xpdl.validation.application", this.applicationName, locale));
        return postfix.toString();
    }

    private String getTranslatedMessagePostfixForTransitionError(Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(this.getTranslatedMessagePostfixForProcessError(locale));
        postfix.append(this.getTranslatedMessagePostfixForError("xpdl.validation.transition", this.transitionId, locale));
        return postfix.toString();
    }

    private String getTranslatedMessagePostfixForError(String componentBundleKey, String componentValue, Locale locale) {
        StringBuilder postfix = new StringBuilder();
        postfix.append(NEW_LINE);
        postfix.append(MessageHelper.getOptionalMessage((String)componentBundleKey, (Locale)locale, (Object[])new Object[0]));
        postfix.append(": ");
        postfix.append("<b>");
        postfix.append(componentValue);
        postfix.append("</b>");
        postfix.append(".");
        return postfix.toString();
    }
}

