/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterValueTypeResolver
extends JsonDeserializer<Object> {
    private Map<String, TypeReference<?>> listTypes = new HashMap();
    private Map<String, Class<?>> types;
    private ObjectMapper om;

    public FilterValueTypeResolver() {
        this.listTypes.put("stringList", new TypeReference<List<String>>(){});
        this.listTypes.put("longList", new TypeReference<List<Long>>(){});
        this.listTypes.put("dateList", new TypeReference<List<Date>>(){});
        this.listTypes.put("doubleList", new TypeReference<List<Double>>(){});
        this.listTypes.put("integerList", new TypeReference<List<Integer>>(){});
        this.types = new HashMap();
        this.types.put("string", String.class);
        this.types.put("long", Long.class);
        this.types.put("date", Date.class);
        this.types.put("double", Double.class);
        this.types.put("integer", Integer.class);
        this.om = new ObjectMapper();
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode tree = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (tree.isObject()) {
            for (String key : this.types.keySet()) {
                if (!tree.has(key)) continue;
                String value = tree.get(key).toString();
                return this.om.readValue(value, this.types.get(key));
            }
            for (String key : this.listTypes.keySet()) {
                if (!tree.has(key)) continue;
                String value = tree.get(key).toString();
                return this.om.readValue(value, this.listTypes.get(key));
            }
        }
        return this.om.readValue(tree.toString(), Object.class);
    }
}

