/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.exception.IllegalExpirationTypeException;
import java.beans.ConstructorProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="pm_docclasses")
@SequenceGenerator(name="pm_docclasses_id_seq", sequenceName="pm_docclasses_id_seq")
public class DocumentClass {
    public static String DEFAULT_LOGICAL_CONNECTION = "AND";
    public static final String JOIN_DEVICE = "directory.device";
    public static final String JOIN_DIRECTORY = "directory";
    public static final String JOIN_INDEXES = "indexes";
    public static final String JOIN_ACTIONS = "actions";
    public static final String JOIN_FILES = "files";
    @Id
    @Column(name="id")
    @Access(value=AccessType.PROPERTY)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_docclasses_id_seq")
    @NonNull
    private Long id;
    @Column(name="docclassname", unique=true)
    private String name;
    @Column(name="docclassdescription")
    private String description;
    @Column(name="maxfilesize")
    private Long maxFileSize;
    @Column(name="docclassexpiretiondate")
    private String expiration;
    @Column(name="docclassexpiretiontype")
    private String expirationType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docclassdirectoryid", nullable=false)
    private Directory directory;
    @Column(name="docclassencoding")
    private boolean encoding;
    @Column(name="docclasscompressing")
    private boolean compressing;
    @Column(name="docclassftsserverid")
    private Long ftsServerId;
    private String cipherAlgorithm;
    private Long keyLength;
    @Column(name="docclassorderid")
    private Long orderId;
    @Column(name="docclassindexpath")
    private String indexPath;
    @Column(name="docclassindex")
    private boolean indexing;
    @Column(name="logicalconn")
    private String logicalConnection = DEFAULT_LOGICAL_CONNECTION;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    private Set<WfFile> files;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    private Set<DocumentClassAction> actions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="documentClass", cascade={CascadeType.ALL})
    private Set<DocumentClassIndex> indexes;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="documentClass")
    private Set<LinkConnection> linkConnections;

    public Set<DocumentClassAction> getActions() {
        if (this.actions == null) {
            return new HashSet<DocumentClassAction>();
        }
        return this.actions;
    }

    public Set<DocumentClassIndex> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new HashSet<DocumentClassIndex>();
        }
        return this.indexes;
    }

    public void addIndex(DocumentClassIndex index) {
        this.getIndexes().add(index);
    }

    public void addAction(DocumentClassAction action) {
        this.getActions().add(action);
    }

    @Transient
    public Date getExpirationDate() throws ParseException, IllegalExpirationTypeException {
        if (this.expirationType == null || StringUtils.isBlank((String)this.expiration)) {
            return null;
        }
        if (this.expirationType.equals("endDay")) {
            return new SimpleDateFormat("y-M-d").parse(this.expiration);
        }
        if (this.expirationType.equals("period") || this.expirationType.equals("dayCnt")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, Integer.valueOf(this.expiration));
            return calendar.getTime();
        }
        return null;
    }

    @NonNull
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getExpirationType() {
        return this.expirationType;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public boolean isEncoding() {
        return this.encoding;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public Long getFtsServerId() {
        return this.ftsServerId;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public Long getKeyLength() {
        return this.keyLength;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public boolean isIndexing() {
        return this.indexing;
    }

    public String getLogicalConnection() {
        return this.logicalConnection;
    }

    public Set<WfFile> getFiles() {
        return this.files;
    }

    public Set<LinkConnection> getLinkConnections() {
        return this.linkConnections;
    }

    public void setId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public void setExpirationType(String expirationType) {
        this.expirationType = expirationType;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public void setFtsServerId(Long ftsServerId) {
        this.ftsServerId = ftsServerId;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public void setKeyLength(Long keyLength) {
        this.keyLength = keyLength;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public void setIndexing(boolean indexing) {
        this.indexing = indexing;
    }

    public void setLogicalConnection(String logicalConnection) {
        this.logicalConnection = logicalConnection;
    }

    public void setFiles(Set<WfFile> files) {
        this.files = files;
    }

    public void setActions(Set<DocumentClassAction> actions) {
        this.actions = actions;
    }

    public void setIndexes(Set<DocumentClassIndex> indexes) {
        this.indexes = indexes;
    }

    public void setLinkConnections(Set<LinkConnection> linkConnections) {
        this.linkConnections = linkConnections;
    }

    public DocumentClass() {
    }

    @ConstructorProperties(value={"id"})
    public DocumentClass(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }
}

