/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.core.type.support.JsonSerializable;
import com.suncode.pwfl.translation.LocalizedString;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class ParameterDefinition<T> {
    private final String id;
    private final LocalizedString name;
    private final LocalizedString description;
    private final Type<T> type;
    private final boolean optional;
    private final T defaultValue;

    public ParameterDefinition(String id, Type<T> type) {
        this(id, type, null, null, false, null);
    }

    public ParameterDefinition(String id, Type<T> type, LocalizedString name, LocalizedString description, boolean optional, T defaultValue) {
        Assert.hasText((String)id);
        Assert.notNull(type);
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.optional = optional;
        this.defaultValue = type.read(defaultValue);
        if (this.defaultValue != null && !(type instanceof JsonSerializable)) {
            throw new IllegalStateException("Parameter [" + this + "] type has default value but cannot be serialized to JSON.");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name != null ? this.name.getOptional() : this.id;
    }

    public String getDescription() {
        return this.description != null ? this.description.getOptional() : null;
    }

    public Type<?> getType() {
        return this.type;
    }

    public boolean isArray() {
        return Types.isArray(this.type);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ParameterDefinition) {
            ParameterDefinition other = (ParameterDefinition)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.name, (Object)other.name).append((Object)this.description, (Object)other.description).append(this.type, other.type).append(this.optional, other.optional).append(this.defaultValue, other.defaultValue).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.name).append((Object)this.description).append(this.type).append(this.optional).append(this.defaultValue).hashCode();
    }

    public String toString() {
        return this.id + "(" + this.type + ")";
    }
}

