/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.suncode.pwfl.search.Pagination;
import java.util.List;
import java.util.Map;

public class DataChooserResult {
    private final Pagination pagination;
    private int total;
    private List<Map<String, String>> data = Lists.newArrayList();

    public DataChooserResult(Pagination pagination) {
        this.pagination = pagination;
    }

    public Row row() {
        if (this.data.size() >= this.pagination.getLimit()) {
            throw new IllegalArgumentException("Data Chooser cannot have more records than defined limit of " + this.pagination.getLimit());
        }
        Row row = new Row();
        this.data.add(row.data());
        return row;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data.clear();
        data.forEach(row -> {
            Row resultRow = this.row();
            row.forEach((key, value) -> resultRow.value((String)key, value == null ? "" : value.toString()));
        });
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setTotal(long total) {
        this.total = Long.valueOf(total).intValue();
    }

    public int getTotal() {
        return this.total;
    }

    public List<Map<String, String>> getData() {
        return this.data;
    }

    public class Row {
        private Map<String, String> row = Maps.newHashMap();

        public Row value(String mappingId, String value) {
            this.row.put(mappingId, value);
            return this;
        }

        Map<String, String> data() {
            return this.row;
        }
    }
}

