/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.component;

import com.google.common.collect.Lists;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.ComponentDefinition;
import com.suncode.pwfl.component.InvokeComponentException;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.support.EmptyInstance;
import com.suncode.pwfl.component.support.InstanceBinder;
import com.suncode.pwfl.component.support.InvocableMethod;
import com.suncode.pwfl.component.support.ParametersBinder;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.WorkflowComponent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.util.Assert;

public abstract class InvocableComponent
extends WorkflowComponent {
    private final InvocableMethod method;
    private final Object instance;

    public InvocableComponent(ComponentDefinition definition, Method method, Object instance) {
        super(definition);
        Assert.notNull((Object)definition, (String)"Definition cannot be null");
        Assert.notNull((Object)method, (String)"Method cannot be null");
        Assert.notNull((Object)instance, (String)"Instance cannot be null");
        this.method = new InvocableMethod(method);
        this.instance = instance;
    }

    public abstract void invoke(Parameters var1, ActivityContextMap var2, ContextVariables var3);

    protected void invoke(Parameters parameters, Object ... instances) {
        ParametersBinder paramBinder = new ParametersBinder(parameters);
        Object[] instancesToBind = this.getInstancesToBind(parameters, instances);
        InstanceBinder instanceBinder = new InstanceBinder(instancesToBind);
        try {
            this.method.invoke(this.instance, paramBinder, instanceBinder);
        }
        catch (Exception e) {
            throw new InvokeComponentException(this, (Throwable)e);
        }
    }

    protected Object invokeWithResult(Parameters parameters, Object ... instances) {
        ParametersBinder paramBinder = new ParametersBinder(parameters);
        Object[] instancesToBind = this.getInstancesToBind(parameters, instances);
        InstanceBinder instanceBinder = new InstanceBinder(instancesToBind);
        try {
            return this.method.invoke(this.instance, paramBinder, instanceBinder);
        }
        catch (Exception e) {
            throw new InvokeComponentException(this, (Throwable)e);
        }
    }

    private Object[] getInstancesToBind(Parameters parameters, Object ... instances) {
        ArrayList instancesToBind = Lists.newArrayList((Object[])instances);
        instancesToBind.add(parameters);
        instancesToBind.add(Translators.get(this.method.getDeclaringClass()));
        instancesToBind.add(UserContext.isActive() ? UserContext.current().getUser() : new EmptyInstance(UserInfo.class));
        return instancesToBind.toArray(new Object[instancesToBind.size()]);
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    protected InvocableMethod getInvocableMethod() {
        return this.method;
    }
}

