/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;

public class DateType
extends JsonTypeBase<LocalDate> {
    public static final DateType INSTANCE = new DateType();

    private DateType() {
        super(LocalDate.class);
    }

    @Override
    public String name() {
        return "date";
    }

    @Override
    public String translationKey() {
        return "Datowy";
    }

    @Override
    protected JsonNode serializeNonNullValue(LocalDate value) {
        return LongNode.valueOf((long)value.toDateTimeAtStartOfDay().getMillis());
    }

    @Override
    protected LocalDate deserializeNonEmptyNode(JsonNode json) {
        return new LocalDate(json.asLong());
    }

    @Override
    public LocalDate convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return LocalDate.parse((String)value);
    }
}

