/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.plusmpm.security.DesEncrypter;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_domainservers")
@SequenceGenerator(name="pm_domainservers_id_seq", sequenceName="pm_domainservers_id_seq")
public class Domain {
    private Long id;
    private String domainName;
    private String domainServerAdres;
    private Long domainServerPort;
    private String domainUser;
    private String domainUserPassword;
    private String domainBaseSearch;
    private String usernameTemplate;
    private String usernameMapping;
    private String firstnameMapping;
    private String lastnameMapping;
    private String emailMapping;
    private String memberMapping;
    private String memberOfMapping;
    private String numberMapping;

    public Domain() {
    }

    public Domain(String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch) {
        this(domainName, domainServerAdres, domainServerPort, domainUser, domainUserPassword, domainBaseSearch, null);
    }

    public Domain(String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch, String usernameTemplate) {
        DesEncrypter d = new DesEncrypter();
        this.domainName = domainName;
        this.domainServerAdres = domainServerAdres;
        this.domainServerPort = domainServerPort;
        this.domainUser = domainUser;
        this.domainUserPassword = d.encrypt(domainUserPassword);
        this.domainBaseSearch = domainBaseSearch;
        this.usernameTemplate = usernameTemplate;
    }

    public Domain(String id, String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch) {
        this(domainName, domainServerAdres, domainServerPort, domainUser, domainUserPassword, domainBaseSearch);
        this.id = Long.parseLong(id);
    }

    @Transient
    public String getDecryptedPassword() {
        if (this.domainUserPassword == null) {
            return null;
        }
        DesEncrypter d = new DesEncrypter();
        return d.decrypt(this.domainUserPassword);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_domainservers_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainServerAdres() {
        return this.domainServerAdres;
    }

    public void setDomainServerAdres(String domainServerAdres) {
        this.domainServerAdres = domainServerAdres;
    }

    public Long getDomainServerPort() {
        return this.domainServerPort;
    }

    public void setDomainServerPort(Long domainServerPort) {
        this.domainServerPort = domainServerPort;
    }

    public String getDomainUser() {
        return this.domainUser;
    }

    public void setDomainUser(String domainUser) {
        this.domainUser = domainUser;
    }

    public String getDomainUserPassword() {
        return this.domainUserPassword;
    }

    public void setDomainUserPassword(String domainUserPassword) {
        this.domainUserPassword = domainUserPassword;
    }

    public String getDomainBaseSearch() {
        return this.domainBaseSearch;
    }

    public void setDomainBaseSearch(String domainBaseSearch) {
        this.domainBaseSearch = domainBaseSearch;
    }

    public String getUsernameTemplate() {
        return this.usernameTemplate;
    }

    public void setUsernameTemplate(String usernameTemplate) {
        this.usernameTemplate = usernameTemplate;
    }

    public String getUsernameMapping() {
        return StringUtils.isEmpty((CharSequence)this.usernameMapping) ? "sAMAccountName" : this.usernameMapping;
    }

    public void setUsernameMapping(String usernameMapping) {
        this.usernameMapping = usernameMapping;
    }

    public String getFirstnameMapping() {
        return StringUtils.isEmpty((CharSequence)this.firstnameMapping) ? "givenname" : this.firstnameMapping;
    }

    public void setFirstnameMapping(String firstnameMapping) {
        this.firstnameMapping = firstnameMapping;
    }

    public String getLastnameMapping() {
        return StringUtils.isEmpty((CharSequence)this.lastnameMapping) ? "sn" : this.lastnameMapping;
    }

    public void setLastnameMapping(String lastnameMapping) {
        this.lastnameMapping = lastnameMapping;
    }

    public String getEmailMapping() {
        return StringUtils.isEmpty((CharSequence)this.emailMapping) ? "mail" : this.emailMapping;
    }

    public void setEmailMapping(String emailMapping) {
        this.emailMapping = emailMapping;
    }

    public String getMemberMapping() {
        return StringUtils.isEmpty((CharSequence)this.memberMapping) ? "member" : this.memberMapping;
    }

    public void setMemberMapping(String memberMapping) {
        this.memberMapping = memberMapping;
    }

    public String getMemberOfMapping() {
        return StringUtils.isEmpty((CharSequence)this.memberOfMapping) ? "memberOf" : this.memberOfMapping;
    }

    public void setMemberOfMapping(String memberOfMapping) {
        this.memberOfMapping = memberOfMapping;
    }

    public String getNumberMapping() {
        return StringUtils.isEmpty((CharSequence)this.numberMapping) ? "physicalDeliveryOfficeName" : this.numberMapping;
    }

    public void setNumberMapping(String numberMapping) {
        this.numberMapping = numberMapping;
    }
}

