/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.field;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.field.DCMapping;
import com.suncode.pwfl.workflow.form.field.DataChooser;
import com.suncode.pwfl.workflow.form.field.UserListAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.xpdl.elements.DataField;
import org.springframework.web.context.request.RequestContextHolder;

public class UserList
extends DataChooser {
    private ActivityService activityService;
    private String name;

    public UserList(ActivityService activityService, boolean window) {
        this.setName("USERLIST");
        this.activityService = activityService;
        this.putUserListTypeToCustomKeys(window);
    }

    public void setDefinition(String varId, String processId, String activityId, DataField dataField, String eaValue) throws IllegalArgumentException {
        this.setClassName("com.plusmpm.util.workflowData.GetFormValues");
        this.setCriteria("GetDataChooserContentServlet_parameter_query");
        this.setMappings(this.buildUserListMappings(varId));
        this.updateUserListCustomKeys(varId, processId, activityId, dataField, eaValue);
    }

    private List<DCMapping> buildUserListMappings(String varId) {
        String[] elementsIds = UserListAttributes.CHOOSER_ELEMENT_IDS;
        String[] elementsNames = UserListAttributes.CHOOSER_ELEMENT_NAMES;
        ArrayList<DCMapping> result = new ArrayList<DCMapping>();
        for (int i = 0; i < elementsIds.length; ++i) {
            String elementFormVarId = "";
            if (elementsIds[i].equals("FIELD_DATA_USER_ID")) {
                elementFormVarId = varId;
            }
            String[] mappingValues = new String[]{elementsIds[i], elementFormVarId, MessageHelper.getOptionalMessage((String)elementsNames[i])};
            DCMapping mappingElement = new DCMapping(mappingValues);
            result.add(mappingElement);
        }
        return result;
    }

    private void putUserListTypeToCustomKeys(boolean window) {
        Map<String, String> customeKeys = this.getCustomKeys();
        customeKeys.put("type", window ? "window" : "combobox");
    }

    private void updateUserListCustomKeys(String varId, String processId, String activityId, DataField dataField, String eaValue) throws IllegalArgumentException {
        Map<String, String> customeKeys = this.getCustomKeys();
        if (eaValue == null || !eaValue.equals(this.name)) {
            throw new IllegalArgumentException("Parameter 'eaValue' value [" + eaValue + "] must be equal '" + this.name + "'.");
        }
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[0], eaValue);
        String variableId = dataField.getId();
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[1], variableId);
        String userName = (String)RequestContextHolder.getRequestAttributes().getAttribute("username", 1);
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[2], userName);
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[3], varId);
        Map<String, Object> activityCtxMap = this.activityService.getActivityContext(processId, activityId);
        String variableValue = (String)activityCtxMap.get(variableId);
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[4], variableValue != null ? variableValue : "");
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[5], processId);
        customeKeys.put(UserListAttributes.CUSTOM_KEYS_KEYS[6], activityId);
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }
}

