/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;

public class FloatType
extends JsonTypeBase<Double> {
    public static final FloatType INSTANCE = new FloatType();

    private FloatType() {
        super(Double.class);
        this.aliasType(Float.class, new TypeBase.Convert<Float, Double>(){

            @Override
            public Float fromBase(Double value) {
                return new Float(value.floatValue());
            }

            @Override
            public Double toBase(Float value) {
                return new Double(value.floatValue());
            }
        });
    }

    @Override
    public String name() {
        return "float";
    }

    @Override
    public String translationKey() {
        return "Zmiennoprzecinkowy";
    }

    @Override
    protected JsonNode serializeNonNullValue(Double value) {
        return DoubleNode.valueOf((double)value);
    }

    @Override
    protected Double deserializeNonEmptyNode(JsonNode json) {
        return json.asDouble();
    }

    @Override
    public Double convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return Double.valueOf(value);
    }
}

