/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.suncode.pwfl.administration.configuration.SystemParameter;
import java.beans.ConstructorProperties;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.NonNull;

@Entity
@Table(name="pm_systemparametercombovalues")
@SequenceGenerator(name="pm_combovalues_seq", sequenceName="pm_combovalues_seq")
public class ComboValue {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_combovalues_seq")
    private Long id;
    @JoinColumn(name="ownerid", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @NonNull
    private SystemParameter systemParameter;
    @NonNull
    private String value;

    public static ComboValueBuilder builder() {
        return new ComboValueBuilder();
    }

    public Long getId() {
        return this.id;
    }

    @NonNull
    public SystemParameter getSystemParameter() {
        return this.systemParameter;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSystemParameter(@NonNull SystemParameter systemParameter) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter");
        }
        this.systemParameter = systemParameter;
    }

    public void setValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public ComboValue() {
    }

    @ConstructorProperties(value={"id", "systemParameter", "value"})
    public ComboValue(Long id, @NonNull SystemParameter systemParameter, @NonNull String value) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.id = id;
        this.systemParameter = systemParameter;
        this.value = value;
    }

    @ConstructorProperties(value={"systemParameter", "value"})
    public ComboValue(@NonNull SystemParameter systemParameter, @NonNull String value) {
        if (systemParameter == null) {
            throw new NullPointerException("systemParameter");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.systemParameter = systemParameter;
        this.value = value;
    }

    public static class ComboValueBuilder {
        private Long id;
        private SystemParameter systemParameter;
        private String value;

        ComboValueBuilder() {
        }

        public ComboValueBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ComboValueBuilder systemParameter(SystemParameter systemParameter) {
            this.systemParameter = systemParameter;
            return this;
        }

        public ComboValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ComboValue build() {
            return new ComboValue(this.id, this.systemParameter, this.value);
        }

        public String toString() {
            return "ComboValue.ComboValueBuilder(id=" + this.id + ", systemParameter=" + this.systemParameter + ", value=" + this.value + ")";
        }
    }
}

