/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;

public class IntegerType
extends JsonTypeBase<Long> {
    public static final IntegerType INSTANCE = new IntegerType();

    private IntegerType() {
        super(Long.class);
        this.aliasType(Integer.class, new TypeBase.Convert<Integer, Long>(){

            @Override
            public Integer fromBase(Long value) {
                return new Integer(value.intValue());
            }

            @Override
            public Long toBase(Integer value) {
                return new Long(value.longValue());
            }
        });
    }

    @Override
    public String name() {
        return "integer";
    }

    @Override
    public String translationKey() {
        return "Calkowity";
    }

    @Override
    protected JsonNode serializeNonNullValue(Long value) {
        return LongNode.valueOf((long)value);
    }

    @Override
    protected Long deserializeNonEmptyNode(JsonNode json) {
        return json.asLong();
    }
}

